/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.ClassFactory;
import com.sun.xml.bind.v2.model.core.Adapter;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.AdaptedLister;
import com.sun.xml.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.bind.v2.runtime.reflect.Lister;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerBoolean;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerByte;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerCharacter;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerDouble;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerFloat;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerInteger;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerLong;
import com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerShort;
import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class Lister<BeanT, PropT, ItemT, PackT> {
    private static final Map<Class, WeakReference<Lister>> arrayListerCache = Collections.synchronizedMap(new WeakHashMap());
    static final Map<Class, Lister> primitiveArrayListers = new HashMap();
    public static final Lister ERROR;
    private static final ListIterator EMPTY_ITERATOR;
    private static final Class[] COLLECTION_IMPL_CLASSES;

    protected Lister() {
    }

    public abstract ListIterator<ItemT> iterator(PropT var1, XMLSerializer var2);

    public abstract PackT startPacking(BeanT var1, Accessor<BeanT, PropT> var2) throws AccessorException;

    public abstract void addToPack(PackT var1, ItemT var2) throws AccessorException;

    public abstract void endPacking(PackT var1, BeanT var2, Accessor<BeanT, PropT> var3) throws AccessorException;

    public abstract void reset(BeanT var1, Accessor<BeanT, PropT> var2) throws AccessorException;

    public static <BeanT, PropT, ItemT, PackT> Lister<BeanT, PropT, ItemT, PackT> create(Type fieldType, ID idness, Adapter<Type, Class> adapter) {
        Lister l;
        Class<Object> itemType;
        Class rawType = Navigator.REFLECTION.erasure(fieldType);
        if (rawType.isArray()) {
            itemType = rawType.getComponentType();
            l = Lister.getArrayLister(itemType);
        } else if (Collection.class.isAssignableFrom(rawType)) {
            Type bt = Navigator.REFLECTION.getBaseClass(fieldType, Collection.class);
            itemType = bt instanceof ParameterizedType ? Navigator.REFLECTION.erasure(((ParameterizedType)bt).getActualTypeArguments()[0]) : Object.class;
            l = new CollectionLister(Lister.getImplClass((Class)rawType));
        } else {
            return null;
        }
        if (idness == ID.IDREF) {
            l = new IDREFS(l, itemType);
        }
        if (adapter != null) {
            l = new AdaptedLister(l, (Class)adapter.adapterType);
        }
        return l;
    }

    private static Class getImplClass(Class<?> fieldType) {
        return ClassFactory.inferImplClass(fieldType, (Class[])COLLECTION_IMPL_CLASSES);
    }

    private static Lister getArrayLister(Class componentType) {
        Lister l = null;
        if (componentType.isPrimitive()) {
            l = (Lister)primitiveArrayListers.get(componentType);
        } else {
            WeakReference wr = (WeakReference)arrayListerCache.get(componentType);
            if (wr != null) {
                l = (Lister)wr.get();
            }
            if (l == null) {
                l = new ArrayLister(componentType);
                arrayListerCache.put(componentType, new WeakReference<Lister>(l));
            }
        }
        assert (l != null);
        return l;
    }

    public static <A, B, C, D> Lister<A, B, C, D> getErrorInstance() {
        return ERROR;
    }

    static /* synthetic */ ListIterator access$300() {
        return EMPTY_ITERATOR;
    }

    static {
        PrimitiveArrayListerBoolean.register();
        PrimitiveArrayListerByte.register();
        PrimitiveArrayListerCharacter.register();
        PrimitiveArrayListerDouble.register();
        PrimitiveArrayListerFloat.register();
        PrimitiveArrayListerInteger.register();
        PrimitiveArrayListerLong.register();
        PrimitiveArrayListerShort.register();
        ERROR = new /* Unavailable Anonymous Inner Class!! */;
        EMPTY_ITERATOR = new /* Unavailable Anonymous Inner Class!! */;
        COLLECTION_IMPL_CLASSES = new Class[]{ArrayList.class, LinkedList.class, HashSet.class, TreeSet.class, Stack.class};
    }
}

