/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.property;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.model.core.PropertyKind;
import com.sun.xml.bind.v2.model.runtime.RuntimeElementPropertyInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimeNonElementRef;
import com.sun.xml.bind.v2.model.runtime.RuntimePropertyInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimeTypeRef;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.property.PropertyImpl;
import com.sun.xml.bind.v2.runtime.property.UnmarshallerChain;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.TransducedAccessor;
import com.sun.xml.bind.v2.runtime.unmarshaller.ChildLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.DefaultValueLoaderDecorator;
import com.sun.xml.bind.v2.runtime.unmarshaller.LeafPropertyLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.LeafPropertyXsiLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.bind.v2.runtime.unmarshaller.XsiNilLoader;
import com.sun.xml.bind.v2.util.QNameMap;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleElementLeafProperty<BeanT>
extends PropertyImpl<BeanT> {
    private final Name tagName;
    private final boolean nillable;
    private final Accessor acc;
    private final String defaultValue;
    private final TransducedAccessor<BeanT> xacc;
    private final boolean improvedXsiTypeHandling;

    public SingleElementLeafProperty(JAXBContextImpl context, RuntimeElementPropertyInfo prop) {
        super(context, (RuntimePropertyInfo)prop);
        RuntimeTypeRef ref = (RuntimeTypeRef)prop.getTypes().get(0);
        this.tagName = context.nameBuilder.createElementName(ref.getTagName());
        assert (this.tagName != null);
        this.nillable = ref.isNillable();
        this.defaultValue = ref.getDefaultValue();
        this.acc = prop.getAccessor().optimize(context);
        this.xacc = TransducedAccessor.get((JAXBContextImpl)context, (RuntimeNonElementRef)ref);
        assert (this.xacc != null);
        this.improvedXsiTypeHandling = context.improvedXsiTypeHandling;
    }

    public void reset(BeanT o) throws AccessorException {
        this.acc.set(o, null);
    }

    public String getIdValue(BeanT bean) throws AccessorException, SAXException {
        return ((Object)this.xacc.print(bean)).toString();
    }

    public void serializeBody(BeanT o, XMLSerializer w, Object outerPeer) throws SAXException, AccessorException, IOException, XMLStreamException {
        boolean hasValue = this.xacc.hasValue(o);
        Object obj = null;
        try {
            obj = this.acc.getUnadapted(o);
        }
        catch (AccessorException ae) {
            // empty catch block
        }
        Class valueType = this.acc.getValueType();
        if (this.improvedXsiTypeHandling && !this.acc.isAdapted() && !valueType.isPrimitive() && this.acc.isValueTypeAbstractable() && obj != null && !obj.getClass().equals(valueType)) {
            w.startElement(this.tagName, outerPeer);
            w.childAsXsiType(obj, this.fieldName, w.grammar.getBeanInfo(valueType), this.nillable);
            w.endElement();
        } else if (hasValue) {
            this.xacc.writeLeafElement(w, this.tagName, o, this.fieldName);
        } else if (this.nillable) {
            w.startElement(this.tagName, null);
            w.writeXsiNilTrue();
            w.endElement();
        }
    }

    public void buildChildElementUnmarshallers(UnmarshallerChain chain, QNameMap<ChildLoader> handlers) {
        LeafPropertyLoader l = new LeafPropertyLoader(this.xacc);
        if (this.defaultValue != null) {
            l = new DefaultValueLoaderDecorator((Loader)l, this.defaultValue);
        }
        if (this.nillable || chain.context.allNillable) {
            l = new XsiNilLoader.Single((Loader)l, this.acc);
        }
        if (this.improvedXsiTypeHandling && !this.nillable) {
            l = new LeafPropertyXsiLoader((Loader)l, this.xacc, this.acc);
        }
        handlers.put(this.tagName, (Object)new ChildLoader((Loader)l, null));
    }

    public PropertyKind getKind() {
        return PropertyKind.ELEMENT;
    }

    public Accessor getElementPropertyAccessor(String nsUri, String localName) {
        if (this.tagName.equals(nsUri, localName)) {
            return this.acc;
        }
        return null;
    }
}

