/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class JAXBStringReaderProviders {
    private static final Map<Class, JAXBContext> jaxbContexts = new WeakHashMap();
    private final Providers ps;
    private final ContextResolver<JAXBContext> context;
    private final ContextResolver<Unmarshaller> unmarshaller;

    public JAXBStringReaderProviders(Providers ps) {
        this.ps = ps;
        this.context = ps.getContextResolver(JAXBContext.class, null);
        this.unmarshaller = ps.getContextResolver(Unmarshaller.class, null);
    }

    protected final Unmarshaller getUnmarshaller(Class type) throws JAXBException {
        Unmarshaller u;
        if (this.unmarshaller != null && (u = (Unmarshaller)this.unmarshaller.getContext(type)) != null) {
            return u;
        }
        return this.getJAXBContext(type).createUnmarshaller();
    }

    private final JAXBContext getJAXBContext(Class type) throws JAXBException {
        JAXBContext c;
        if (this.context != null && (c = (JAXBContext)this.context.getContext(type)) != null) {
            return c;
        }
        return this.getStoredJAXBContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getStoredJAXBContext(Class type) throws JAXBException {
        Map map = jaxbContexts;
        synchronized (map) {
            JAXBContext c = (JAXBContext)jaxbContexts.get(type);
            if (c == null) {
                c = JAXBContext.newInstance((Class[])new Class[]{type});
                jaxbContexts.put(type, c);
            }
            return c;
        }
    }
}

