/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import com.sun.jersey.server.impl.model.parameter.multivalued.AbstractStringReaderExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.CollectionStringReaderExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import com.sun.jersey.spi.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.core.MultivaluedMap;

abstract class CollectionStringReaderExtractor<V extends Collection>
extends AbstractStringReaderExtractor {
    protected CollectionStringReaderExtractor(StringReader sr, String parameter, String defaultStringValue) {
        super(sr, parameter, defaultStringValue);
    }

    public Object extract(MultivaluedMap<String, String> parameters) {
        List stringList = (List)parameters.get((Object)this.parameter);
        if (stringList != null) {
            Collection valueList = this.getInstance();
            for (String v : stringList) {
                valueList.add(v.length() == 0 ? null : this.sr.fromString(v));
            }
            return valueList;
        }
        if (this.defaultStringValue != null) {
            Collection valueList = this.getInstance();
            valueList.add(this.sr.fromString(this.defaultStringValue));
            return valueList;
        }
        return this.getInstance();
    }

    protected abstract V getInstance();

    static MultivaluedParameterExtractor getInstance(Class c, StringReader sr, String parameter, String defaultValueString) {
        if (List.class == c) {
            return new ListValueOf(sr, parameter, defaultValueString);
        }
        if (Set.class == c) {
            return new SetValueOf(sr, parameter, defaultValueString);
        }
        if (SortedSet.class == c) {
            return new SortedSetValueOf(sr, parameter, defaultValueString);
        }
        throw new RuntimeException();
    }
}

