/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.application;

import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.api.container.filter.UriConnegFilter;
import com.sun.jersey.api.core.ExtendedUriInfo;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.InjectParam;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.core.ResourceConfigurator;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.api.model.AbstractModelComponent;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceModelContext;
import com.sun.jersey.api.model.AbstractResourceModelListener;
import com.sun.jersey.api.model.ResourceModelIssue;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ProviderFactory;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessor;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactory;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactoryInitializer;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCProviderFactory;
import com.sun.jersey.core.spi.factory.ContextResolverFactory;
import com.sun.jersey.core.spi.factory.InjectableProviderFactory;
import com.sun.jersey.core.spi.factory.MessageBodyFactory;
import com.sun.jersey.core.util.FeaturesAndProperties;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.server.impl.BuildId;
import com.sun.jersey.server.impl.ThreadLocalHttpContext;
import com.sun.jersey.server.impl.application.CloseableServiceFactory;
import com.sun.jersey.server.impl.application.DeferredResourceConfig;
import com.sun.jersey.server.impl.application.ExceptionMapperFactory;
import com.sun.jersey.server.impl.application.ResourceMethodDispatcherFactory;
import com.sun.jersey.server.impl.application.RootResourceUriRules;
import com.sun.jersey.server.impl.application.WebApplicationContext;
import com.sun.jersey.server.impl.application.WebApplicationImpl;
import com.sun.jersey.server.impl.component.IoCResourceFactory;
import com.sun.jersey.server.impl.component.ResourceFactory;
import com.sun.jersey.server.impl.container.filter.FilterFactory;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderContext;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderFactory;
import com.sun.jersey.server.impl.model.ResourceUriRules;
import com.sun.jersey.server.impl.model.RulesMap;
import com.sun.jersey.server.impl.model.parameter.CookieParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.FormParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.HeaderParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.HttpContextInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.MatrixParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.PathParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.QueryParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorFactory;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorProvider;
import com.sun.jersey.server.impl.model.parameter.multivalued.StringReaderFactory;
import com.sun.jersey.server.impl.modelapi.annotation.IntrospectionModeller;
import com.sun.jersey.server.impl.modelapi.validation.BasicValidator;
import com.sun.jersey.server.impl.monitoring.MonitoringProviderFactory;
import com.sun.jersey.server.impl.resource.PerRequestFactory;
import com.sun.jersey.server.impl.template.TemplateFactory;
import com.sun.jersey.server.impl.uri.rules.RootResourceClassesRule;
import com.sun.jersey.server.impl.wadl.WadlApplicationContextInjectionProxy;
import com.sun.jersey.server.impl.wadl.WadlFactory;
import com.sun.jersey.server.spi.component.ResourceComponentProvider;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.StringReaderWorkers;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.ExceptionMapperContext;
import com.sun.jersey.spi.container.ResourceMethodCustomInvokerDispatchFactory;
import com.sun.jersey.spi.container.ResourceMethodDispatchProvider;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.WebApplicationListener;
import com.sun.jersey.spi.inject.Errors;
import com.sun.jersey.spi.inject.Inject;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import com.sun.jersey.spi.inject.ServerSide;
import com.sun.jersey.spi.monitoring.DispatchingListener;
import com.sun.jersey.spi.monitoring.RequestListener;
import com.sun.jersey.spi.monitoring.ResponseListener;
import com.sun.jersey.spi.service.ServiceFinder;
import com.sun.jersey.spi.template.TemplateContext;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import com.sun.jersey.spi.uri.rules.UriRules;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;

public final class WebApplicationImpl
implements WebApplication {
    private static final Logger LOGGER = Logger.getLogger(WebApplicationImpl.class.getName());
    private final Map<Class, AbstractResource> abstractResourceMap = new HashMap();
    private final ConcurrentMap<Class, UriRules<UriRule>> rulesMap = new ConcurrentHashMap();
    private final ConcurrentMap<Class, ResourceComponentProvider> providerMap = new ConcurrentHashMap();
    private final ConcurrentMap<ClassAnnotationKey, ResourceComponentProvider> providerWithAnnotationKeyMap = new ConcurrentHashMap();
    private final ThreadLocalHttpContext context;
    private final CloseableServiceFactory closeableFactory;
    private boolean initiated;
    private ResourceConfig resourceConfig;
    private RootResourceClassesRule rootsRule;
    private ServerInjectableProviderFactory injectableFactory;
    private ProviderFactory cpFactory;
    private ResourceFactory rcpFactory;
    private IoCComponentProviderFactory provider;
    private List<IoCComponentProviderFactory> providerFactories;
    private Providers providers;
    private MessageBodyFactory bodyFactory;
    private StringReaderFactory stringReaderFactory;
    private TemplateContext templateContext;
    private ExceptionMapperFactory exceptionFactory;
    private ResourceMethodDispatchProvider dispatcherFactory;
    private ResourceContext resourceContext;
    private Set<AbstractResource> abstractRootResources;
    private Map<String, AbstractResource> explicitAbstractRootResources;
    private final AbstractResourceModelContext armContext = new /* Unavailable Anonymous Inner Class!! */;
    private FilterFactory filterFactory;
    private WadlFactory wadlFactory;
    private boolean isTraceEnabled;
    private RequestListener requestListener;
    private DispatchingListenerProxy dispatchingListener;
    private ResponseListener responseListener;
    private static final IoCComponentProcessor NULL_COMPONENT_PROCESSOR = new /* Unavailable Anonymous Inner Class!! */;

    public WebApplicationImpl() {
        this.context = new ThreadLocalHttpContext();
        2 requestHandler = new /* Unavailable Anonymous Inner Class!! */;
        3 uriInfoHandler = new /* Unavailable Anonymous Inner Class!! */;
        this.injectableFactory = new ServerInjectableProviderFactory();
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(InjectableProviderContext.class, (Object)this.injectableFactory));
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(ServerInjectableProviderContext.class, (Object)this.injectableFactory));
        HashMap<Class, Object> m = new HashMap<Class, Object>();
        m.put(HttpContext.class, this.context);
        m.put(HttpHeaders.class, this.createProxy(HttpHeaders.class, (InvocationHandler)requestHandler));
        m.put(UriInfo.class, this.createProxy(UriInfo.class, (InvocationHandler)uriInfoHandler));
        m.put(ExtendedUriInfo.class, this.createProxy(ExtendedUriInfo.class, (InvocationHandler)uriInfoHandler));
        m.put(Request.class, this.createProxy(Request.class, (InvocationHandler)requestHandler));
        m.put(SecurityContext.class, this.createProxy(SecurityContext.class, (InvocationHandler)requestHandler));
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.closeableFactory = new CloseableServiceFactory((HttpContext)this.context);
        this.injectableFactory.add((InjectableProvider)this.closeableFactory);
    }

    public FeaturesAndProperties getFeaturesAndProperties() {
        return this.resourceConfig;
    }

    public WebApplication clone() {
        WebApplicationImpl wa = new WebApplicationImpl();
        wa.initiate(this.resourceConfig, this.provider);
        return wa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UriRules<UriRule> getUriRules(Class c) {
        assert (c != null);
        UriRules r = (UriRules)this.rulesMap.get(c);
        if (r != null) {
            return r;
        }
        Map map = this.abstractResourceMap;
        synchronized (map) {
            r = (UriRules)this.rulesMap.get(c);
            if (r != null) {
                return r;
            }
            r = ((ResourceUriRules)Errors.processWithErrors((Errors.Closure)new /* Unavailable Anonymous Inner Class!! */)).getRules();
            this.rulesMap.put(c, r);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceComponentProvider getResourceComponentProvider(Class c) {
        assert (c != null);
        ResourceComponentProvider rcp = (ResourceComponentProvider)this.providerMap.get(c);
        if (rcp != null) {
            return rcp;
        }
        Map map = this.abstractResourceMap;
        synchronized (map) {
            rcp = (ResourceComponentProvider)this.providerMap.get(c);
            if (rcp != null) {
                return rcp;
            }
            ResourceComponentProvider _rcp = rcp = this.rcpFactory.getComponentProvider(null, c);
            Errors.processWithErrors((Errors.Closure)new /* Unavailable Anonymous Inner Class!! */);
            this.providerMap.put(c, rcp);
        }
        return rcp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceComponentProvider getResourceComponentProvider(ComponentContext cc, Class c) {
        ClassAnnotationKey cak;
        ResourceComponentProvider rcp;
        assert (c != null);
        if (cc == null || cc.getAnnotations().length == 0) {
            return this.getResourceComponentProvider(c);
        }
        if (cc.getAnnotations().length == 1) {
            String value;
            Inject i;
            Annotation a = cc.getAnnotations()[0];
            if (a.annotationType() == Inject.class) {
                i = (Inject)Inject.class.cast(a);
                String string = value = i.value() != null ? i.value().trim() : "";
                if (value.isEmpty()) {
                    return this.getResourceComponentProvider(c);
                }
            } else if (a.annotationType() == InjectParam.class) {
                i = (InjectParam)InjectParam.class.cast(a);
                String string = value = i.value() != null ? i.value().trim() : "";
                if (value.isEmpty()) {
                    return this.getResourceComponentProvider(c);
                }
            }
        }
        if ((rcp = (ResourceComponentProvider)this.providerWithAnnotationKeyMap.get(cak = new ClassAnnotationKey(c, cc.getAnnotations()))) != null) {
            return rcp;
        }
        Map map = this.abstractResourceMap;
        synchronized (map) {
            rcp = (ResourceComponentProvider)this.providerWithAnnotationKeyMap.get(cak);
            if (rcp != null) {
                return rcp;
            }
            ResourceComponentProvider _rcp = rcp = this.rcpFactory.getComponentProvider(cc, c);
            Errors.processWithErrors((Errors.Closure)new /* Unavailable Anonymous Inner Class!! */);
            this.providerWithAnnotationKeyMap.put(cak, rcp);
        }
        return rcp;
    }

    void initiateResource(AbstractResource ar) {
        this.initiateResource(ar.getResourceClass());
    }

    void initiateResource(Class c) {
        this.getUriRules(c);
        this.getResourceComponentProvider(c);
    }

    void initiateResource(AbstractResource ar, Object resource) {
        Class c = ar.getResourceClass();
        this.getUriRules(c);
        if (!this.providerMap.containsKey(c)) {
            this.providerMap.put(c, new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    Set<AbstractResource> getAbstractRootResources() {
        return this.abstractRootResources;
    }

    Map<String, AbstractResource> getExplicitAbstractRootResources() {
        return this.explicitAbstractRootResources;
    }

    private ResourceUriRules newResourceUriRules(AbstractResource ar) {
        assert (null != ar);
        BasicValidator validator = new BasicValidator();
        validator.validate((AbstractModelComponent)ar);
        for (ResourceModelIssue issue : validator.getIssueList()) {
            Errors.error((String)issue.getMessage(), (boolean)issue.isFatal());
        }
        return new ResourceUriRules(this.resourceConfig, this.getDispatchProvider(), (ServerInjectableProviderContext)this.injectableFactory, this.filterFactory, this.wadlFactory, (DispatchingListener)this.dispatchingListener, ar);
    }

    protected ResourceMethodDispatchProvider getDispatchProvider() {
        return this.dispatcherFactory;
    }

    public RequestListener getRequestListener() {
        return this.requestListener;
    }

    public DispatchingListener getDispatchingListener() {
        return this.dispatchingListener;
    }

    public ResponseListener getResponseListener() {
        return this.responseListener;
    }

    AbstractResource getAbstractResource(Object o) {
        return this.getAbstractResource(o.getClass());
    }

    AbstractResource getAbstractResource(Class c) {
        AbstractResource ar = (AbstractResource)this.abstractResourceMap.get(c);
        if (ar == null) {
            ar = IntrospectionModeller.createResource((Class)c);
            this.abstractResourceMap.put(c, ar);
        }
        return ar;
    }

    public boolean isInitiated() {
        return this.initiated;
    }

    public void initiate(ResourceConfig resourceConfig) {
        this.initiate(resourceConfig, null);
    }

    public void initiate(ResourceConfig rc, IoCComponentProviderFactory _provider) {
        Errors.processWithErrors((Errors.Closure)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void _initiate(ResourceConfig rc, IoCComponentProviderFactory _provider) {
        if (rc == null) {
            throw new IllegalArgumentException("ResourceConfig instance MUST NOT be null");
        }
        if (this.initiated) {
            throw new ContainerException(ImplMessages.WEB_APP_ALREADY_INITIATED());
        }
        this.initiated = true;
        LOGGER.info("Initiating Jersey application, version '" + BuildId.getBuildId() + "'");
        Class[] components = ServiceFinder.find((String)"jersey-server-components").toClassArray();
        if (components.length > 0) {
            if (LOGGER.isLoggable(Level.INFO)) {
                StringBuilder b = new StringBuilder();
                b.append("Adding the following classes declared in META-INF/services/jersey-server-components to the resource configuration:");
                for (Class c : components) {
                    b.append('\n').append("  ").append(c);
                }
                LOGGER.log(Level.INFO, b.toString());
            }
            this.resourceConfig = rc.clone();
            this.resourceConfig.getClasses().addAll(Arrays.asList(components));
        } else {
            this.resourceConfig = rc;
        }
        this.provider = _provider;
        this.providerFactories = new ArrayList(2);
        for (Object o : this.resourceConfig.getProviderSingletons()) {
            if (!(o instanceof IoCComponentProviderFactory)) continue;
            this.providerFactories.add((IoCComponentProviderFactory)o);
        }
        if (_provider != null) {
            this.providerFactories.add(_provider);
        }
        this.cpFactory = this.providerFactories.isEmpty() ? new ProviderFactory((InjectableProviderContext)this.injectableFactory) : new IoCProviderFactory((InjectableProviderContext)this.injectableFactory, this.providerFactories);
        this.rcpFactory = this.providerFactories.isEmpty() ? new ResourceFactory(this.resourceConfig, (ServerInjectableProviderContext)this.injectableFactory) : new IoCResourceFactory(this.resourceConfig, (ServerInjectableProviderContext)this.injectableFactory, this.providerFactories);
        for (IoCComponentProviderFactory f : this.providerFactories) {
            if (!(f instanceof IoCComponentProcessorFactoryInitializer)) continue;
            ComponentProcessorFactoryImpl cpf = new ComponentProcessorFactoryImpl(this, null);
            IoCComponentProcessorFactoryInitializer i = (IoCComponentProcessorFactoryInitializer)f;
            i.init((IoCComponentProcessorFactory)cpf);
        }
        this.resourceContext = new /* Unavailable Anonymous Inner Class!! */;
        ProviderServices providerServices = new ProviderServices(ServerSide.class, this.cpFactory, this.resourceConfig.getProviderClasses(), this.resourceConfig.getProviderSingletons());
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(ProviderServices.class, (Object)providerServices));
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(ResourceMethodCustomInvokerDispatchFactory.class, (Object)new ResourceMethodCustomInvokerDispatchFactory(providerServices)));
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(FeaturesAndProperties.class, (Object)this.resourceConfig));
        this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(ResourceContext.class, (Object)this.resourceContext));
        this.injectableFactory.configure(providerServices);
        boolean updateRequired = false;
        if (rc instanceof DeferredResourceConfig) {
            DeferredResourceConfig drc = (DeferredResourceConfig)rc;
            if (this.resourceConfig == drc) {
                this.resourceConfig = drc.clone();
            }
            DeferredResourceConfig.ApplicationHolder da = drc.getApplication(this.cpFactory);
            this.resourceConfig.add(da.getApplication());
            updateRequired = true;
            this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(Application.class, (Object)da.getOriginalApplication()));
        } else {
            this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(Application.class, (Object)this.resourceConfig));
        }
        for (ResourceConfigurator configurator : providerServices.getProviders(ResourceConfigurator.class)) {
            configurator.configure(this.resourceConfig);
            updateRequired = true;
        }
        this.resourceConfig.validate();
        if (updateRequired) {
            providerServices.update(this.resourceConfig.getProviderClasses(), this.resourceConfig.getProviderSingletons(), (InjectableProviderFactory)this.injectableFactory);
        }
        this.templateContext = new TemplateFactory(providerServices);
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(TemplateContext.class, (Object)this.templateContext));
        ContextResolverFactory crf = new ContextResolverFactory();
        this.exceptionFactory = new ExceptionMapperFactory();
        this.bodyFactory = new MessageBodyFactory(providerServices, this.getFeaturesAndProperties().getFeature("com.sun.jersey.config.feature.Pre14ProviderPrecedence"));
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(MessageBodyWorkers.class, (Object)this.bodyFactory));
        this.providers = new /* Unavailable Anonymous Inner Class!! */;
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(Providers.class, (Object)this.providers));
        this.stringReaderFactory = new StringReaderFactory();
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(StringReaderWorkers.class, (Object)this.stringReaderFactory));
        MultivaluedParameterExtractorFactory mpep = new MultivaluedParameterExtractorFactory((StringReaderWorkers)this.stringReaderFactory);
        this.injectableFactory.add((InjectableProvider)new ContextInjectableProvider(MultivaluedParameterExtractorProvider.class, (Object)mpep));
        this.injectableFactory.add((InjectableProvider)new CookieParamInjectableProvider((MultivaluedParameterExtractorProvider)mpep));
        this.injectableFactory.add((InjectableProvider)new HeaderParamInjectableProvider((MultivaluedParameterExtractorProvider)mpep));
        this.injectableFactory.add((InjectableProvider)new HttpContextInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new MatrixParamInjectableProvider((MultivaluedParameterExtractorProvider)mpep));
        this.injectableFactory.add((InjectableProvider)new PathParamInjectableProvider((MultivaluedParameterExtractorProvider)mpep));
        this.injectableFactory.add((InjectableProvider)new QueryParamInjectableProvider((MultivaluedParameterExtractorProvider)mpep));
        this.injectableFactory.add((InjectableProvider)new FormParamInjectableProvider((MultivaluedParameterExtractorProvider)mpep));
        this.filterFactory = new FilterFactory(providerServices);
        this.dispatcherFactory = ResourceMethodDispatcherFactory.create((ProviderServices)providerServices);
        this.dispatchingListener = new DispatchingListenerProxy(this, null);
        this.wadlFactory = new WadlFactory(this.resourceConfig);
        WadlApplicationContextInjectionProxy wadlApplicationContextInjectionProxy = null;
        if (!this.resourceConfig.getFeature("com.sun.jersey.config.feature.DisableWADL")) {
            wadlApplicationContextInjectionProxy = new WadlApplicationContextInjectionProxy();
            this.injectableFactory.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.filterFactory.init(this.resourceConfig);
        if (!this.resourceConfig.getMediaTypeMappings().isEmpty() || !this.resourceConfig.getLanguageMappings().isEmpty()) {
            boolean present = false;
            for (ContainerRequestFilter f : this.filterFactory.getRequestFilters()) {
                present |= f instanceof UriConnegFilter;
            }
            if (!present) {
                this.filterFactory.getRequestFilters().add(new UriConnegFilter(this.resourceConfig.getMediaTypeMappings(), this.resourceConfig.getLanguageMappings()));
            } else {
                LOGGER.warning("The media type and language mappings declared in the ResourceConfig are ignored because there is an instance of " + UriConnegFilter.class.getName() + "present in the list of request filters.");
            }
        }
        crf.init(providerServices, (InjectableProviderFactory)this.injectableFactory);
        this.exceptionFactory.init(providerServices);
        this.bodyFactory.init();
        this.stringReaderFactory.init(providerServices);
        Errors.setReportMissingDependentFieldOrMethod((boolean)true);
        this.cpFactory.injectOnAllComponents();
        this.cpFactory.injectOnProviderInstances((Collection)this.resourceConfig.getProviderSingletons());
        for (IoCComponentProviderFactory providerFactory : this.providerFactories) {
            if (!(providerFactory instanceof WebApplicationListener)) continue;
            WebApplicationListener listener = (WebApplicationListener)providerFactory;
            listener.onWebApplicationReady();
        }
        this.createAbstractResourceModelStructures();
        RulesMap rootRules = new RootResourceUriRules(this, this.resourceConfig, this.wadlFactory, (InjectableProviderFactory)this.injectableFactory).getRules();
        this.rootsRule = new RootResourceClassesRule((Map)rootRules);
        if (!this.resourceConfig.getFeature("com.sun.jersey.config.feature.DisableWADL")) {
            wadlApplicationContextInjectionProxy.init(this.wadlFactory);
        }
        this.requestListener = MonitoringProviderFactory.createRequestListener((ProviderServices)providerServices);
        this.responseListener = MonitoringProviderFactory.createResponseListener((ProviderServices)providerServices);
        this.dispatchingListener.init(providerServices);
        this.callAbstractResourceModelListenersOnLoaded(providerServices);
        this.isTraceEnabled = this.resourceConfig.getFeature("com.sun.jersey.config.feature.Trace") | this.resourceConfig.getFeature("com.sun.jersey.config.feature.TracePerRequest");
    }

    public Providers getProviders() {
        return this.providers;
    }

    public MessageBodyWorkers getMessageBodyWorkers() {
        return this.bodyFactory;
    }

    public ExceptionMapperContext getExceptionMapperContext() {
        return this.exceptionFactory;
    }

    public ServerInjectableProviderFactory getServerInjectableProviderFactory() {
        return this.injectableFactory;
    }

    public void handleRequest(ContainerRequest request, ContainerResponseWriter responseWriter) throws IOException {
        ContainerResponse response = new ContainerResponse((WebApplication)this, request, responseWriter);
        this.handleRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(ContainerRequest request, ContainerResponse response) throws IOException {
        WebApplicationContext localContext = new WebApplicationContext(this, request, response);
        this.context.set((HttpContext)localContext);
        try {
            this._handleRequest(localContext, request, response);
        }
        finally {
            PerRequestFactory.destroy((HttpContext)localContext);
            this.closeableFactory.close((HttpContext)localContext);
            this.context.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebApplicationContext handleMatchResourceRequest(URI u) {
        WebApplicationContext oldContext = (WebApplicationContext)this.context.get();
        WebApplicationContext newContext = oldContext.createMatchResourceContext(u);
        this.context.set((HttpContext)newContext);
        try {
            this._handleRequest(newContext, newContext.getContainerRequest());
            WebApplicationContext webApplicationContext = newContext;
            return webApplicationContext;
        }
        finally {
            this.context.set((HttpContext)oldContext);
        }
    }

    public void destroy() {
        for (ResourceComponentProvider rcp : this.providerMap.values()) {
            rcp.destroy();
        }
        for (ResourceComponentProvider rcp : this.providerWithAnnotationKeyMap.values()) {
            rcp.destroy();
        }
        this.cpFactory.destroy();
    }

    public boolean isTracingEnabled() {
        return this.isTraceEnabled;
    }

    public void trace(String message) {
        this.context.get().trace(message);
    }

    private void _handleRequest(WebApplicationContext localContext, ContainerRequest request, ContainerResponse response) throws IOException {
        block14: {
            block13: {
                try {
                    this.requestListener.onRequest(Thread.currentThread().getId(), request);
                    this._handleRequest(localContext, request);
                }
                catch (WebApplicationException e) {
                    response.mapWebApplicationException(e);
                }
                catch (MappableContainerException e) {
                    response.mapMappableContainerException(e);
                }
                catch (RuntimeException e) {
                    if (response.mapException((Throwable)e)) break block13;
                    LOGGER.log(Level.SEVERE, "The RuntimeException could not be mapped to a response, re-throwing to the HTTP container", e);
                    throw e;
                }
            }
            try {
                for (ContainerResponseFilter f : localContext.getResponseFilters()) {
                    response = f.filter(request, response);
                    localContext.setContainerResponse(response);
                }
                for (ContainerResponseFilter f : this.filterFactory.getResponseFilters()) {
                    response = f.filter(request, response);
                    localContext.setContainerResponse(response);
                }
            }
            catch (WebApplicationException e) {
                response.mapWebApplicationException(e);
            }
            catch (MappableContainerException e) {
                response.mapMappableContainerException(e);
            }
            catch (RuntimeException e) {
                if (response.mapException((Throwable)e)) break block14;
                LOGGER.log(Level.SEVERE, "The RuntimeException could not be mapped to a response, re-throwing to the HTTP container", e);
                throw e;
            }
        }
        try {
            response.write();
            this.responseListener.onResponse(Thread.currentThread().getId(), response);
        }
        catch (WebApplicationException e) {
            if (response.isCommitted()) {
                LOGGER.log(Level.SEVERE, "The response of the WebApplicationException cannot be utilized as the response is already committed. Re-throwing to the HTTP container", e);
                throw e;
            }
            response.mapWebApplicationException(e);
            response.write();
        }
    }

    private void _handleRequest(WebApplicationContext localContext, ContainerRequest request) {
        for (ContainerRequestFilter f : this.filterFactory.getRequestFilters()) {
            request = f.filter(request);
            localContext.setContainerRequest(request);
        }
        StringBuilder path = new StringBuilder();
        path.append("/").append(request.getPath(false));
        if (!this.resourceConfig.getFeature("com.sun.jersey.config.feature.IgnoreMatrixParams")) {
            path = this.stripMatrixParams(path);
        }
        if (!this.rootsRule.accept((CharSequence)path, null, (UriRuleContext)localContext)) {
            throw new NotFoundException(request.getRequestUri());
        }
    }

    public HttpContext getThreadLocalHttpContext() {
        return this.context;
    }

    private StringBuilder stripMatrixParams(StringBuilder path) {
        int e = path.indexOf(";");
        if (e == -1) {
            return path;
        }
        int s = 0;
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(path, s, e);
        } while ((s = path.indexOf("/", e + 1)) != -1 && (e = path.indexOf(";", s)) != -1);
        if (s != -1) {
            sb.append(path, s, path.length());
        }
        return sb;
    }

    private void createAbstractResourceModelStructures() {
        HashSet<AbstractResource> rootARs = new HashSet<AbstractResource>();
        for (Object o : this.resourceConfig.getRootResourceSingletons()) {
            rootARs.add(this.getAbstractResource(o));
        }
        for (Class c : this.resourceConfig.getRootResourceClasses()) {
            rootARs.add(this.getAbstractResource(c));
        }
        HashMap explicitRootARs = new HashMap();
        for (Map.Entry e : this.resourceConfig.getExplicitRootResources().entrySet()) {
            Object o = e.getValue();
            Class<?> c = o instanceof Class ? (Class<?>)o : o.getClass();
            AbstractResource ar = new AbstractResource((String)e.getKey(), this.getAbstractResource(c));
            rootARs.add(ar);
            explicitRootARs.put(e.getKey(), ar);
        }
        this.abstractRootResources = Collections.unmodifiableSet(rootARs);
        this.explicitAbstractRootResources = Collections.unmodifiableMap(explicitRootARs);
    }

    private void callAbstractResourceModelListenersOnLoaded(ProviderServices providerServices) {
        for (AbstractResourceModelListener aml : providerServices.getProviders(AbstractResourceModelListener.class)) {
            aml.onLoaded(this.armContext);
        }
    }

    private <T> T createProxy(Class<T> c, InvocationHandler i) {
        return c.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{c}, i));
    }

    static /* synthetic */ Set access$000(WebApplicationImpl x0) {
        return x0.abstractRootResources;
    }

    static /* synthetic */ ThreadLocalHttpContext access$100(WebApplicationImpl x0) {
        return x0.context;
    }

    static /* synthetic */ ServerInjectableProviderFactory access$200(WebApplicationImpl x0) {
        return x0.injectableFactory;
    }

    static /* synthetic */ ResourceFactory access$300(WebApplicationImpl x0) {
        return x0.rcpFactory;
    }

    static /* synthetic */ IoCComponentProcessor access$400() {
        return NULL_COMPONENT_PROCESSOR;
    }

    static /* synthetic */ Map access$500(WebApplicationImpl x0) {
        return x0.abstractResourceMap;
    }

    static /* synthetic */ ResourceUriRules access$600(WebApplicationImpl x0, AbstractResource x1) {
        return x0.newResourceUriRules(x1);
    }

    static /* synthetic */ void access$700(WebApplicationImpl x0, ResourceConfig x1, IoCComponentProviderFactory x2) {
        x0._initiate(x1, x2);
    }

    static /* synthetic */ WebApplicationContext access$900(WebApplicationImpl x0, URI x1) {
        return x0.handleMatchResourceRequest(x1);
    }

    static /* synthetic */ ResourceConfig access$1000(WebApplicationImpl x0) {
        return x0.resourceConfig;
    }

    static /* synthetic */ MessageBodyFactory access$1100(WebApplicationImpl x0) {
        return x0.bodyFactory;
    }

    static /* synthetic */ ExceptionMapperFactory access$1200(WebApplicationImpl x0) {
        return x0.exceptionFactory;
    }
}

