/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.util;

import com.sun.jersey.core.util.KeyComparator;
import com.sun.jersey.core.util.KeyComparatorHashMap;
import com.sun.jersey.impl.ImplMessages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class KeyComparatorHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<K, V>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    final KeyComparator<K> keyComparator;
    static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;

    public int getDEFAULT_INITIAL_CAPACITY() {
        return 16;
    }

    public KeyComparatorHashMap(int initialCapacity, float loadFactor, KeyComparator<K> keyComparator) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(ImplMessages.ILLEGAL_INITIAL_CAPACITY((Object)initialCapacity));
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException(ImplMessages.ILLEGAL_LOAD_FACTOR((Object)Float.valueOf(loadFactor)));
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
        this.keyComparator = keyComparator;
    }

    public KeyComparatorHashMap(int initialCapacity, KeyComparator<K> keyComparator) {
        this(initialCapacity, 0.75f, keyComparator);
    }

    public KeyComparatorHashMap(KeyComparator<K> keyComparator) {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
        this.keyComparator = keyComparator;
    }

    public KeyComparatorHashMap(Map<? extends K, ? extends V> m, KeyComparator<K> keyComparator) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, keyComparator);
        this.putAllForCreate(m);
    }

    public int getModCount() {
        return this.modCount;
    }

    void init() {
    }

    static <T> T maskNull(T key) {
        return (T)(key == null ? NULL_KEY : key);
    }

    static <T> boolean isNull(T key) {
        return key == NULL_KEY;
    }

    static <T> T unmaskNull(T key) {
        return key == NULL_KEY ? null : (T)key;
    }

    static int hash(Object x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    int keyComparatorHash(K k) {
        return KeyComparatorHashMap.isNull(k) ? this.hash(k.hashCode()) : this.hash(this.keyComparator.hash(k));
    }

    int hash(int h) {
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    boolean keyComparatorEq(K x, K y) {
        if (KeyComparatorHashMap.isNull(x)) {
            return x == y;
        }
        if (KeyComparatorHashMap.isNull(y)) {
            return x == y;
        }
        return x == y || this.keyComparator.equals(x, y);
    }

    @Override
    public V get(Object key) {
        Object k = KeyComparatorHashMap.maskNull((Object)key);
        int hash = this.keyComparatorHash(k);
        int i = KeyComparatorHashMap.indexFor((int)hash, (int)this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && this.keyComparatorEq(k, e.key)) {
                return (V)e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        Object k = KeyComparatorHashMap.maskNull((Object)key);
        int hash = this.keyComparatorHash(k);
        int i = KeyComparatorHashMap.indexFor((int)hash, (int)this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && this.keyComparatorEq(k, e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    Entry<K, V> getEntry(K key) {
        Object k = KeyComparatorHashMap.maskNull(key);
        int hash = this.keyComparatorHash(k);
        int i = KeyComparatorHashMap.indexFor((int)hash, (int)this.table.length);
        Entry e = this.table[i];
        while (!(e == null || e.hash == hash && this.keyComparatorEq(k, e.key))) {
            e = e.next;
        }
        return e;
    }

    @Override
    public V put(K key, V value) {
        Object k = KeyComparatorHashMap.maskNull(key);
        int hash = this.keyComparatorHash(k);
        int i = KeyComparatorHashMap.indexFor((int)hash, (int)this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && this.keyComparatorEq(k, e.key)) {
                Object oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return (V)oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, k, value, i);
        return null;
    }

    private void putForCreate(K key, V value) {
        Object k = KeyComparatorHashMap.maskNull(key);
        int hash = this.keyComparatorHash(k);
        int i = KeyComparatorHashMap.indexFor((int)hash, (int)this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && this.keyComparatorEq(k, e.key)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, k, value, i);
    }

    void putAllForCreate(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry<K, V>[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = KeyComparatorHashMap.indexFor((int)e.hash, (int)newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry e = this.removeEntryForKey(key);
        return (V)(e == null ? null : e.value);
    }

    Entry<K, V> removeEntryForKey(Object key) {
        Entry prev;
        Object k = KeyComparatorHashMap.maskNull((Object)key);
        int hash = this.keyComparatorHash(k);
        int i = KeyComparatorHashMap.indexFor((int)hash, (int)this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && this.keyComparatorEq(k, e.key)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    Entry<K, V> removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object k = KeyComparatorHashMap.maskNull(entry.getKey());
        int hash = this.keyComparatorHash(k);
        int i = KeyComparatorHashMap.indexFor((int)hash, (int)this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals((Object)entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() {
        KeyComparatorHashMap result = null;
        try {
            result = (KeyComparatorHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate((Map)this);
        return result;
    }

    void addEntry(int hash, K key, V value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, K key, V value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, key, value, e);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator(this, null);
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator(this, null);
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator(this, null);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(this, null));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator i = this.entrySet().iterator();
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }
}

