/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.scanning.uri;

import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.core.spi.scanning.ScannerException;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.core.spi.scanning.uri.UriSchemeScanner;
import com.sun.jersey.core.util.Closing;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JarZipSchemeScanner
implements UriSchemeScanner {
    public Set<String> getSchemes() {
        return new HashSet<String>(Arrays.asList("jar", "zip"));
    }

    public void scan(URI u, ScannerListener cfl) {
        String ssp = u.getRawSchemeSpecificPart();
        String jarUrlString = ssp.substring(0, ssp.lastIndexOf(33));
        String parent = ssp.substring(ssp.lastIndexOf(33) + 2);
        try {
            this.closing(jarUrlString).f((Closing.Closure)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException ex) {
            throw new ScannerException("IO error when scanning jar " + u, (Throwable)ex);
        }
    }

    protected Closing closing(String jarUrlString) throws IOException {
        try {
            return new Closing(new URL(jarUrlString).openStream());
        }
        catch (MalformedURLException ex) {
            return new Closing((InputStream)new FileInputStream(UriComponent.decode((String)jarUrlString, (UriComponent.Type)UriComponent.Type.PATH)));
        }
    }
}

