/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.factory;

import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.core.spi.factory.ContextResolverFactory;
import com.sun.jersey.core.spi.factory.InjectableProviderFactory;
import com.sun.jersey.core.spi.factory.MessageBodyFactory;
import com.sun.jersey.core.util.KeyComparatorHashMap;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;

public class ContextResolverFactory {
    private final Map<Type, Map<MediaType, ContextResolver>> resolver = new HashMap(4);
    private final Map<Type, ConcurrentHashMap<MediaType, ContextResolver>> cache = new HashMap(4);
    private static final NullContextResolverAdapter NULL_CONTEXT_RESOLVER = new NullContextResolverAdapter(null);

    public void init(ProviderServices providersServices, InjectableProviderFactory ipf) {
        HashMap rs = new HashMap();
        Set providers = providersServices.getProviders(ContextResolver.class);
        for (ContextResolver contextResolver : providers) {
            List ms = MediaTypes.createMediaTypes((Produces)contextResolver.getClass().getAnnotation(Produces.class));
            Type type = this.getParameterizedType(contextResolver.getClass());
            HashMap<MediaType, ArrayList<ContextResolver>> mr = (HashMap<MediaType, ArrayList<ContextResolver>>)rs.get(type);
            if (mr == null) {
                mr = new HashMap<MediaType, ArrayList<ContextResolver>>();
                rs.put(type, mr);
            }
            for (MediaType m : ms) {
                ArrayList<ContextResolver> crl = (ArrayList<ContextResolver>)mr.get(m);
                if (crl == null) {
                    crl = new ArrayList<ContextResolver>();
                    mr.put(m, crl);
                }
                crl.add(contextResolver);
            }
        }
        for (Map.Entry entry : rs.entrySet()) {
            KeyComparatorHashMap mr = new KeyComparatorHashMap(4, MessageBodyFactory.MEDIA_TYPE_COMPARATOR);
            this.resolver.put(entry.getKey(), mr);
            this.cache.put(entry.getKey(), new ConcurrentHashMap(4));
            for (Map.Entry f : ((Map)entry.getValue()).entrySet()) {
                mr.put(f.getKey(), this.reduce((List)f.getValue()));
            }
        }
        ipf.add((InjectableProvider)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Type getParameterizedType(Class c) {
        ReflectionHelper.DeclaringClassInterfacePair p = ReflectionHelper.getClass((Class)c, ContextResolver.class);
        Type[] as = ReflectionHelper.getParameterizedTypeArguments((ReflectionHelper.DeclaringClassInterfacePair)p);
        return as != null ? as[0] : Object.class;
    }

    private ContextResolver reduce(List<ContextResolver> r) {
        if (r.size() == 1) {
            return r.iterator().next();
        }
        return new ContextResolverAdapter(r);
    }

    public <T> ContextResolver<T> resolve(Type t, MediaType m) {
        ContextResolver cr;
        ConcurrentHashMap crMapCache = (ConcurrentHashMap)this.cache.get(t);
        if (crMapCache == null) {
            return null;
        }
        if (m == null) {
            m = MediaTypes.GENERAL_MEDIA_TYPE;
        }
        if ((cr = (ContextResolver)crMapCache.get(m)) == null) {
            ContextResolver _cr;
            Map crMap = (Map)this.resolver.get(t);
            if (m.isWildcardType()) {
                cr = (ContextResolver)crMap.get(MediaTypes.GENERAL_MEDIA_TYPE);
                if (cr == null) {
                    cr = NULL_CONTEXT_RESOLVER;
                }
            } else if (m.isWildcardSubtype()) {
                ContextResolver subTypeWildCard = (ContextResolver)crMap.get(m);
                ContextResolver wildCard = (ContextResolver)crMap.get(MediaTypes.GENERAL_MEDIA_TYPE);
                cr = new ContextResolverAdapter(new ContextResolver[]{subTypeWildCard, wildCard}).reduce();
            } else {
                ContextResolver type = (ContextResolver)crMap.get(m);
                ContextResolver subTypeWildCard = (ContextResolver)crMap.get(new MediaType(m.getType(), "*"));
                ContextResolver wildCard = (ContextResolver)crMap.get(MediaType.WILDCARD_TYPE);
                cr = new ContextResolverAdapter(new ContextResolver[]{type, subTypeWildCard, wildCard}).reduce();
            }
            if ((_cr = crMapCache.putIfAbsent(m, cr)) != null) {
                cr = _cr;
            }
        }
        return cr != NULL_CONTEXT_RESOLVER ? cr : null;
    }

    static /* synthetic */ Map access$000(ContextResolverFactory x0) {
        return x0.resolver;
    }

    static /* synthetic */ NullContextResolverAdapter access$200() {
        return NULL_CONTEXT_RESOLVER;
    }
}

