/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OsgiLocator {
    private static Map<String, List<Callable<List<Class>>>> factories = new HashMap();
    private static ReadWriteLock lock = new ReentrantReadWriteLock();

    private OsgiLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String id, Callable<List<Class>> factory) {
        lock.writeLock().lock();
        try {
            List l = (List)factories.get(id);
            if (l != null) {
                l.remove(factory);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String id, Callable<List<Class>> factory) {
        lock.writeLock().lock();
        try {
            ArrayList<Callable<List<Class>>> l = (ArrayList<Callable<List<Class>>>)factories.get(id);
            if (l == null) {
                l = new ArrayList<Callable<List<Class>>>();
                factories.put(id, l);
            }
            l.add(factory);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Class locate(String factoryId) {
        lock.readLock().lock();
        try {
            List classes;
            List l = (List)factories.get(factoryId);
            if (l == null || l.isEmpty()) {
                Class clazz = null;
                return clazz;
            }
            Callable c = (Callable)l.get(l.size() - 1);
            try {
                classes = (List)c.call();
            }
            catch (Exception e) {
                Class clazz = null;
                lock.readLock().unlock();
                return clazz;
            }
            Class clazz = (Class)classes.get(0);
            return clazz;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static synchronized List<Class> locateAll(String factoryId) {
        ArrayList<Class> classes = new ArrayList<Class>();
        List l = (List)factories.get(factoryId);
        if (l == null) {
            return classes;
        }
        for (Callable c : l) {
            try {
                classes.addAll((Collection)c.call());
            }
            catch (Exception e) {}
        }
        return classes;
    }
}

