/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.uri;

import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.api.uri.UriPattern;
import com.sun.jersey.api.uri.UriTemplateParser;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * Exception performing whole class analysis ignored.
 */
public class UriTemplate {
    public static final Comparator<UriTemplate> COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    private static final Pattern TEMPLATE_NAMES_PATTERN = Pattern.compile("\\{(\\w[-\\w\\.]*)\\}");
    public static final UriTemplate EMPTY = new UriTemplate();
    private final String template;
    private final String normalizedTemplate;
    private final UriPattern pattern;
    private final boolean endsWithSlash;
    private final List<String> templateVariables;
    private final int numOfExplicitRegexes;
    private final int numOfCharacters;

    private UriTemplate() {
        this.normalizedTemplate = "";
        this.template = "";
        this.pattern = UriPattern.EMPTY;
        this.endsWithSlash = false;
        this.templateVariables = Collections.emptyList();
        this.numOfCharacters = 0;
        this.numOfExplicitRegexes = 0;
    }

    public UriTemplate(String template) throws PatternSyntaxException, IllegalArgumentException {
        this(new UriTemplateParser(template));
    }

    protected UriTemplate(UriTemplateParser templateParser) throws PatternSyntaxException, IllegalArgumentException {
        this.template = templateParser.getTemplate();
        this.normalizedTemplate = templateParser.getNormalizedTemplate();
        this.pattern = this.createUriPattern(templateParser);
        this.numOfExplicitRegexes = templateParser.getNumberOfExplicitRegexes();
        this.numOfCharacters = templateParser.getNumberOfLiteralCharacters();
        this.endsWithSlash = this.template.charAt(this.template.length() - 1) == '/';
        this.templateVariables = Collections.unmodifiableList(templateParser.getNames());
    }

    protected UriPattern createUriPattern(UriTemplateParser templateParser) {
        return new UriPattern(templateParser.getPattern(), templateParser.getGroupIndexes());
    }

    public final String getTemplate() {
        return this.template;
    }

    public final UriPattern getPattern() {
        return this.pattern;
    }

    public final boolean endsWithSlash() {
        return this.endsWithSlash;
    }

    public final List<String> getTemplateVariables() {
        return this.templateVariables;
    }

    public final boolean isTemplateVariablePresent(String name) {
        for (String s : this.templateVariables) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public final int getNumberOfExplicitRegexes() {
        return this.numOfExplicitRegexes;
    }

    public final int getNumberOfExplicitCharacters() {
        return this.numOfCharacters;
    }

    public final int getNumberOfTemplateVariables() {
        return this.templateVariables.size();
    }

    public final boolean match(CharSequence uri, Map<String, String> templateVariableToValue) throws IllegalArgumentException {
        if (templateVariableToValue == null) {
            throw new IllegalArgumentException();
        }
        return this.pattern.match(uri, this.templateVariables, templateVariableToValue);
    }

    public final boolean match(CharSequence uri, List<String> groupValues) throws IllegalArgumentException {
        if (groupValues == null) {
            throw new IllegalArgumentException();
        }
        return this.pattern.match(uri, groupValues);
    }

    public final String createURI(Map<String, String> values) {
        StringBuilder b = new StringBuilder();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(this.normalizedTemplate);
        int i = 0;
        while (m.find()) {
            b.append(this.normalizedTemplate, i, m.start());
            String tValue = values.get(m.group(1));
            if (tValue != null) {
                b.append(tValue);
            }
            i = m.end();
        }
        b.append(this.normalizedTemplate, i, this.normalizedTemplate.length());
        return b.toString();
    }

    public final String createURI(String ... values) {
        return this.createURI(values, 0, values.length);
    }

    public final String createURI(String[] values, int offset, int length) {
        HashMap<String, String> mapValues = new HashMap<String, String>();
        StringBuilder b = new StringBuilder();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(this.normalizedTemplate);
        int v = offset;
        length += offset;
        int i = 0;
        while (m.find()) {
            b.append(this.normalizedTemplate, i, m.start());
            String tVariable = m.group(1);
            String tValue = (String)mapValues.get(tVariable);
            if (tValue != null) {
                b.append(tValue);
            } else if (v < length && (tValue = values[v++]) != null) {
                mapValues.put(tVariable, tValue);
                b.append(tValue);
            }
            i = m.end();
        }
        b.append(this.normalizedTemplate, i, this.normalizedTemplate.length());
        return b.toString();
    }

    public final String toString() {
        return this.pattern.toString();
    }

    public final int hashCode() {
        return this.pattern.hashCode();
    }

    public final boolean equals(Object o) {
        if (o instanceof UriTemplate) {
            UriTemplate that = (UriTemplate)o;
            return this.pattern.equals((Object)that.pattern);
        }
        return false;
    }

    public static final String createURI(String scheme, String userInfo, String host, String port, String path, String query, String fragment, Map<String, ? extends Object> values, boolean encode) {
        return UriTemplate.createURI((String)scheme, null, (String)userInfo, (String)host, (String)port, (String)path, (String)query, (String)fragment, values, (boolean)encode);
    }

    public static final String createURI(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, Map<String, ? extends Object> values, boolean encode) {
        HashMap<String, String> stringValues = new HashMap<String, String>();
        for (Map.Entry<String, ? extends Object> e : values.entrySet()) {
            if (e.getValue() == null) continue;
            stringValues.put(e.getKey(), e.getValue().toString());
        }
        return UriTemplate.createURIWithStringValues((String)scheme, (String)authority, (String)userInfo, (String)host, (String)port, (String)path, (String)query, (String)fragment, stringValues, (boolean)encode);
    }

    public static final String createURIWithStringValues(String scheme, String userInfo, String host, String port, String path, String query, String fragment, Map<String, ? extends Object> values, boolean encode) {
        return UriTemplate.createURIWithStringValues((String)scheme, null, (String)userInfo, (String)host, (String)port, (String)path, (String)query, (String)fragment, values, (boolean)encode);
    }

    public static final String createURIWithStringValues(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, Map<String, ? extends Object> values, boolean encode) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.SCHEME, (String)scheme, values, (boolean)false, (StringBuilder)sb).append(':');
        }
        if (userInfo != null || host != null || port != null) {
            sb.append("//");
            if (userInfo != null && userInfo.length() > 0) {
                UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.USER_INFO, (String)userInfo, values, (boolean)encode, (StringBuilder)sb).append('@');
            }
            if (host != null) {
                UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.HOST, (String)host, values, (boolean)encode, (StringBuilder)sb);
            }
            if (port != null && port.length() > 0) {
                sb.append(':');
                UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.PORT, (String)port, values, (boolean)false, (StringBuilder)sb);
            }
        } else if (authority != null) {
            sb.append("//");
            UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.AUTHORITY, (String)authority, values, (boolean)encode, (StringBuilder)sb);
        }
        if (path != null) {
            UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.PATH, (String)path, values, (boolean)encode, (StringBuilder)sb);
        }
        if (query != null && query.length() > 0) {
            sb.append('?');
            UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.QUERY_PARAM, (String)query, values, (boolean)encode, (StringBuilder)sb);
        }
        if (fragment != null && fragment.length() > 0) {
            sb.append('#');
            UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.FRAGMENT, (String)fragment, values, (boolean)encode, (StringBuilder)sb);
        }
        return sb.toString();
    }

    private static StringBuilder createURIComponent(UriComponent.Type t, String template, Map<String, ? extends Object> values, boolean encode, StringBuilder b) {
        if (template.indexOf(123) == -1) {
            b.append(template);
            return b;
        }
        template = new UriTemplateParser(template).getNormalizedTemplate();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(template);
        int i = 0;
        while (m.find()) {
            b.append(template, i, m.start());
            Object tValue = values.get(m.group(1));
            if (tValue == null) {
                throw UriTemplate.templateVariableHasNoValue((String)m.group(1));
            }
            tValue = encode ? UriComponent.encode((String)tValue.toString(), (UriComponent.Type)t) : UriComponent.contextualEncode((String)tValue.toString(), (UriComponent.Type)t);
            b.append(tValue);
            i = m.end();
        }
        b.append(template, i, template.length());
        return b;
    }

    public static final String createURI(String scheme, String userInfo, String host, String port, String path, String query, String fragment, Object[] values, boolean encode) {
        return UriTemplate.createURI((String)scheme, null, (String)userInfo, (String)host, (String)port, (String)path, (String)query, (String)fragment, (Object[])values, (boolean)encode);
    }

    public static final String createURI(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, Object[] values, boolean encode) {
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            stringValues[i] = values[i].toString();
        }
        return UriTemplate.createURIWithStringValues((String)scheme, (String)authority, (String)userInfo, (String)host, (String)port, (String)path, (String)query, (String)fragment, (String[])stringValues, (boolean)encode);
    }

    public static final String createURIWithStringValues(String scheme, String userInfo, String host, String port, String path, String query, String fragment, String[] values, boolean encode) {
        return UriTemplate.createURIWithStringValues((String)scheme, null, (String)userInfo, (String)host, (String)port, (String)path, (String)query, (String)fragment, (String[])values, (boolean)encode);
    }

    public static final String createURIWithStringValues(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, String[] values, boolean encode) {
        HashMap mapValues = new HashMap();
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        if (scheme != null) {
            offset = UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.SCHEME, (String)scheme, (String[])values, (int)offset, (boolean)false, mapValues, (StringBuilder)sb);
            sb.append(':');
        }
        if (userInfo != null || host != null || port != null) {
            sb.append("//");
            if (userInfo != null && userInfo.length() > 0) {
                offset = UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.USER_INFO, (String)userInfo, (String[])values, (int)offset, (boolean)encode, mapValues, (StringBuilder)sb);
                sb.append('@');
            }
            if (host != null) {
                offset = UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.HOST, (String)host, (String[])values, (int)offset, (boolean)encode, mapValues, (StringBuilder)sb);
            }
            if (port != null && port.length() > 0) {
                sb.append(':');
                offset = UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.PORT, (String)port, (String[])values, (int)offset, (boolean)false, mapValues, (StringBuilder)sb);
            }
        } else if (authority != null) {
            sb.append("//");
            offset = UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.AUTHORITY, (String)authority, (String[])values, (int)offset, (boolean)encode, mapValues, (StringBuilder)sb);
        }
        if (path != null) {
            offset = UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.PATH, (String)path, (String[])values, (int)offset, (boolean)encode, mapValues, (StringBuilder)sb);
        }
        if (query != null && query.length() > 0) {
            sb.append('?');
            offset = UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.QUERY_PARAM, (String)query, (String[])values, (int)offset, (boolean)encode, mapValues, (StringBuilder)sb);
        }
        if (fragment != null && fragment.length() > 0) {
            sb.append('#');
            offset = UriTemplate.createURIComponent((UriComponent.Type)UriComponent.Type.FRAGMENT, (String)fragment, (String[])values, (int)offset, (boolean)encode, mapValues, (StringBuilder)sb);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int createURIComponent(UriComponent.Type t, String template, String[] values, int offset, boolean encode, Map<String, String> mapValues, StringBuilder b) {
        if (template.indexOf(123) == -1) {
            b.append(template);
            return offset;
        }
        template = new UriTemplateParser(template).getNormalizedTemplate();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(template);
        int v = offset;
        int i = 0;
        while (m.find()) {
            b.append(template, i, m.start());
            String tVariable = m.group(1);
            String tValue = mapValues.get(tVariable);
            if (tValue != null) {
                b.append(tValue);
            } else {
                if (v >= values.length) throw UriTemplate.templateVariableHasNoValue((String)tVariable);
                if ((tValue = values[v++]) == null) throw UriTemplate.templateVariableHasNoValue((String)tVariable);
                tValue = encode ? UriComponent.encode((String)tValue, (UriComponent.Type)t) : UriComponent.contextualEncode((String)tValue, (UriComponent.Type)t);
                mapValues.put(tVariable, tValue);
                b.append(tValue);
            }
            i = m.end();
        }
        b.append(template, i, template.length());
        return v;
    }

    private static IllegalArgumentException templateVariableHasNoValue(String tVariable) {
        return new IllegalArgumentException("The template variable, " + tVariable + ", has no value");
    }

    static /* synthetic */ UriPattern access$000(UriTemplate x0) {
        return x0.pattern;
    }
}

