/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client.filter;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientRequestAdapter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class GZIPContentEncodingFilter
extends ClientFilter {
    private final boolean compressRequestEntity;

    public GZIPContentEncodingFilter() {
        this(true);
    }

    public GZIPContentEncodingFilter(boolean compressRequestEntity) {
        this.compressRequestEntity = compressRequestEntity;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        String encodings;
        ClientResponse response;
        if (!request.getHeaders().containsKey((Object)"Accept-Encoding")) {
            request.getHeaders().add((Object)"Accept-Encoding", (Object)"gzip");
        }
        if (request.getEntity() != null) {
            Object o = request.getHeaders().getFirst((Object)"Content-Encoding");
            if (o != null && o.equals("gzip")) {
                request.setAdapter((ClientRequestAdapter)new Adapter(request.getAdapter()));
            } else if (this.compressRequestEntity) {
                request.getHeaders().add((Object)"Content-Encoding", (Object)"gzip");
                request.setAdapter((ClientRequestAdapter)new Adapter(request.getAdapter()));
            }
        }
        if ((response = this.getNext().handle(request)).hasEntity() && response.getHeaders().containsKey((Object)"Content-Encoding") && (encodings = (String)response.getHeaders().getFirst((Object)"Content-Encoding")).equals("gzip")) {
            response.getHeaders().remove((Object)"Content-Encoding");
            try {
                response.setEntityInputStream((InputStream)new GZIPInputStream(response.getEntityInputStream()));
            }
            catch (IOException ex) {
                throw new ClientHandlerException((Throwable)ex);
            }
        }
        return response;
    }
}

