/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client.filter;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientRequestAdapter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.ClientRequestContainer;
import com.sun.jersey.api.client.filter.ConnectionListenerFilter;
import com.sun.jersey.api.client.filter.ContainerListener;
import com.sun.jersey.api.client.filter.OnStartConnectionListener;
import com.sun.jersey.api.client.filter.ReportingInputStream;
import java.io.InputStream;

public class ConnectionListenerFilter
extends ClientFilter {
    private final OnStartConnectionListener listenerFactory;

    public ConnectionListenerFilter(OnStartConnectionListener listenerFactory) {
        if (listenerFactory == null) {
            throw new IllegalArgumentException("ConnectionListenerFilter can't be initiated without OnStartConnectionListener");
        }
        this.listenerFactory = listenerFactory;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        ContainerListener listener = this.listenerFactory.onStart((ClientRequest)new ClientRequestContainer(request));
        request.setAdapter((ClientRequestAdapter)new Adapter(request.getAdapter(), listener));
        ClientResponse response = this.getNext().handle(request);
        if (response.hasEntity()) {
            InputStream entityInputStream = response.getEntityInputStream();
            listener.onReceiveStart((long)response.getLength());
            response.setEntityInputStream((InputStream)new ReportingInputStream(entityInputStream, listener));
        } else {
            listener.onFinish();
        }
        return response;
    }
}

