/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.RequestWriter;
import com.sun.jersey.spi.MessageBodyWorkers;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;

public class RequestWriter {
    private static final Logger LOGGER = Logger.getLogger(RequestWriter.class.getName());
    protected static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private MessageBodyWorkers workers;

    public RequestWriter() {
    }

    public RequestWriter(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    @Context
    public void setMessageBodyWorkers(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    public MessageBodyWorkers getMessageBodyWorkers() {
        return this.workers;
    }

    protected RequestEntityWriter getRequestEntityWriter(ClientRequest ro) {
        return new RequestEntityWriterImpl(this, ro);
    }

    protected void writeRequestEntity(ClientRequest ro, RequestEntityWriterListener listener) throws IOException {
        Object entity = ro.getEntity();
        if (entity == null) {
            return;
        }
        Type entityType = null;
        if (entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)entity;
            entityType = ge.getType();
            entity = ge.getEntity();
        } else {
            entityType = entity.getClass();
        }
        Class<?> entityClass = entity.getClass();
        MultivaluedMap headers = ro.getHeaders();
        MediaType mediaType = this.getMediaType(entityClass, entityType, headers);
        MessageBodyWriter bw = this.workers.getMessageBodyWriter(entityClass, entityType, EMPTY_ANNOTATIONS, mediaType);
        if (bw == null) {
            throw new ClientHandlerException("A message body writer for Java type, " + entity.getClass() + ", and MIME media type, " + mediaType + ", was not found");
        }
        long size = headers.containsKey((Object)"Content-Encoding") ? -1L : bw.getSize(entity, entityClass, entityType, EMPTY_ANNOTATIONS, mediaType);
        listener.onRequestEntitySize(size);
        OutputStream out = ro.getAdapter().adapt(ro, listener.onGetOutputStream());
        try {
            bw.writeTo(entity, entityClass, entityType, EMPTY_ANNOTATIONS, mediaType, headers, out);
            out.flush();
        }
        catch (IOException ex) {
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw ex;
        }
        out.close();
    }

    private MediaType getMediaType(Class entityClass, Type entityType, MultivaluedMap<String, Object> headers) {
        Object mediaTypeHeader = headers.getFirst((Object)"Content-Type");
        if (mediaTypeHeader instanceof MediaType) {
            return (MediaType)mediaTypeHeader;
        }
        if (mediaTypeHeader != null) {
            return MediaType.valueOf((String)mediaTypeHeader.toString());
        }
        List mediaTypes = this.workers.getMessageBodyWriterMediaTypes(entityClass, entityType, EMPTY_ANNOTATIONS);
        MediaType mediaType = this.getMediaType(mediaTypes);
        headers.putSingle((Object)"Content-Type", (Object)mediaType);
        return mediaType;
    }

    private MediaType getMediaType(List<MediaType> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        MediaType mediaType = mediaTypes.get(0);
        if (mediaType.isWildcardType() || mediaType.isWildcardSubtype()) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        return mediaType;
    }

    static /* synthetic */ MediaType access$000(RequestWriter x0, Class x1, Type x2, MultivaluedMap x3) {
        return x0.getMediaType(x1, x2, x3);
    }

    static /* synthetic */ MessageBodyWorkers access$100(RequestWriter x0) {
        return x0.workers;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

