/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.AggregatorOperations;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.SortOperations;
import com.terracottatech.search.StackOperations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SearchBuilder {
    private final List queryStack = new ArrayList();
    private final List<NVPair> aggregatorList = new ArrayList<NVPair>();
    private final Set<String> attributes = new HashSet<String>();
    private final Set<String> groupByAttrs = new HashSet<String>();
    private final List<NVPair> sortAttributes = new ArrayList<NVPair>();
    private boolean includeKeys = false;
    private boolean includeValues = false;
    private int maxResults = -1;
    private long requesterId = -1L;
    private long queryId = -1L;
    private int batchSize = -1;

    public SearchBuilder includeKeys(boolean include) {
        this.includeKeys = include;
        return this;
    }

    public SearchBuilder includeValues(boolean include) {
        this.includeValues = include;
        return this;
    }

    public SearchBuilder attributeAscending(String attributeName) {
        this.sortAttributes.add(AbstractNVPair.createNVPair(attributeName, (Object)SortOperations.ASCENDING));
        return this;
    }

    public SearchBuilder attributeDescending(String attributeName) {
        this.sortAttributes.add(AbstractNVPair.createNVPair(attributeName, (Object)SortOperations.DESCENDING));
        return this;
    }

    public SearchBuilder groupBy(String attributeName) {
        this.groupByAttrs.add(attributeName);
        return this;
    }

    public SearchBuilder attribute(String attributeName) {
        this.attributes.add(attributeName);
        return this;
    }

    public SearchBuilder all() {
        this.add((Object)StackOperations.ALL);
        return this;
    }

    public SearchBuilder and() {
        this.add((Object)StackOperations.AND);
        return this;
    }

    public SearchBuilder or() {
        this.add((Object)StackOperations.OR);
        return this;
    }

    public SearchBuilder beginGroup() {
        this.add((Object)StackOperations.BEGIN_GROUP);
        return this;
    }

    public SearchBuilder endGroup() {
        this.add((Object)StackOperations.END_GROUP);
        return this;
    }

    public SearchBuilder ilike(String name, Object value) {
        this.add((Object)StackOperations.ILIKE);
        this.add(AbstractNVPair.createNVPair(name, value));
        return this;
    }

    public SearchBuilder notIlike(String name, String regex) {
        this.add((Object)StackOperations.NOT_ILIKE);
        this.add(AbstractNVPair.createNVPair(name, regex));
        return this;
    }

    public SearchBuilder isNull(String name) {
        this.add((Object)StackOperations.NULL);
        this.add(AbstractNVPair.createNVPair(name, null));
        return this;
    }

    public SearchBuilder notNull(String name) {
        this.add((Object)StackOperations.NOT_NULL);
        this.add(AbstractNVPair.createNVPair(name, null));
        return this;
    }

    public SearchBuilder greaterThan(String name, Object value) {
        this.add((Object)StackOperations.GREATER_THAN);
        this.add(AbstractNVPair.createNVPair(name, value));
        return this;
    }

    public SearchBuilder greaterThanEqual(String name, Object value) {
        this.add((Object)StackOperations.GREATER_THAN_EQUAL);
        this.add(AbstractNVPair.createNVPair(name, value));
        return this;
    }

    public SearchBuilder lessThan(String name, Object value) {
        this.add((Object)StackOperations.LESS_THAN);
        this.add(AbstractNVPair.createNVPair(name, value));
        return this;
    }

    public SearchBuilder lessThanEqual(String name, Object value) {
        this.add((Object)StackOperations.LESS_THAN_EQUAL);
        this.add(AbstractNVPair.createNVPair(name, value));
        return this;
    }

    public SearchBuilder between(String name1, Object value1, String name2, Object value2, boolean minInclusive, boolean maxInclusive) {
        this.add((Object)StackOperations.BETWEEN);
        this.add(AbstractNVPair.createNVPair(name1, value1));
        this.add(AbstractNVPair.createNVPair(name2, value2));
        this.add(AbstractNVPair.createNVPair("MIN_INCLUSIVE", minInclusive));
        this.add(AbstractNVPair.createNVPair("MAX_INCLUSIVE", maxInclusive));
        return this;
    }

    public SearchBuilder term(String attributeName, Object value) {
        this.add((Object)StackOperations.TERM);
        this.add(AbstractNVPair.createNVPair(attributeName, value));
        return this;
    }

    public SearchBuilder notEqualTerm(String attributeName, Object value) {
        this.add((Object)StackOperations.NOT_TERM);
        this.add(AbstractNVPair.createNVPair(attributeName, value));
        return this;
    }

    public SearchBuilder count() {
        this.aggregatorList.add(AbstractNVPair.createNVPair("COUNT", (Object)AggregatorOperations.COUNT));
        return this;
    }

    public SearchBuilder sum(String attributeName) {
        this.aggregatorList.add(AbstractNVPair.createNVPair(attributeName, (Object)AggregatorOperations.SUM));
        return this;
    }

    public SearchBuilder average(String attributeName) {
        this.aggregatorList.add(AbstractNVPair.createNVPair(attributeName, (Object)AggregatorOperations.AVERAGE));
        return this;
    }

    public SearchBuilder max(String attributeName) {
        this.aggregatorList.add(AbstractNVPair.createNVPair(attributeName, (Object)AggregatorOperations.MAX));
        return this;
    }

    public SearchBuilder min(String attributeName) {
        this.aggregatorList.add(AbstractNVPair.createNVPair(attributeName, (Object)AggregatorOperations.MIN));
        return this;
    }

    public SearchBuilder maxResults(int max) {
        this.maxResults = max;
        return this;
    }

    public SearchBuilder requesterId(long id) {
        this.requesterId = id;
        return this;
    }

    public SearchBuilder queryId(long id) {
        this.queryId = id;
        return this;
    }

    public SearchBuilder batchSize(int size) {
        this.batchSize = size;
        return this;
    }

    private void add(Object obj) {
        this.queryStack.add(obj);
    }

    public Search build() {
        return new Search(this.includeKeys, this.includeValues, this.queryStack, this.attributes, this.groupByAttrs, this.aggregatorList, this.sortAttributes, this.maxResults, this.batchSize, this.requesterId, this.queryId);
    }

    public static class Search {
        private final boolean includeKeys;
        private final boolean includeValues;
        private final List queryStack;
        private final Set<String> attributes;
        private final Set<String> groupByAttrs;
        private final List<NVPair> aggregatorList;
        private final List<NVPair> sortAttributes;
        private final int maxResults;
        private final int batchSize;
        private final long requesterId;
        private final long queryId;
        public static final int BATCH_SIZE_UNLIMITED = -1;

        private Search(boolean includeKeys, boolean includeValues, List queryStack, Set<String> attributes, Set<String> groupByAttrs, List<NVPair> aggregatorList, List<NVPair> sortAttributes, int maxResults, int batchSize, long requesterId, long queryId) {
            this.includeKeys = includeKeys;
            this.includeValues = includeValues;
            this.queryStack = Collections.unmodifiableList(new ArrayList(queryStack));
            this.attributes = Collections.unmodifiableSet(new HashSet<String>(attributes));
            this.groupByAttrs = Collections.unmodifiableSet(new HashSet<String>(groupByAttrs));
            this.aggregatorList = Collections.unmodifiableList(new ArrayList<NVPair>(aggregatorList));
            this.sortAttributes = Collections.unmodifiableList(new ArrayList<NVPair>(sortAttributes));
            this.maxResults = maxResults;
            this.batchSize = batchSize;
            this.requesterId = requesterId;
            this.queryId = queryId;
        }

        public boolean isIncludeKeys() {
            return this.includeKeys;
        }

        public boolean isIncludeValues() {
            return this.includeValues;
        }

        public List getQueryStack() {
            return this.queryStack;
        }

        public Set<String> getAttributes() {
            return this.attributes;
        }

        public Set<String> getGroupByAttrs() {
            return this.groupByAttrs;
        }

        public List<NVPair> getAggregatorList() {
            return this.aggregatorList;
        }

        public List<NVPair> getSortAttributes() {
            return this.sortAttributes;
        }

        public int getMaxResults() {
            return this.maxResults;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public long getRequesterId() {
            return this.requesterId;
        }

        public long getQueryId() {
            return this.queryId;
        }
    }
}

