/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.RandomAccess;
import com.terracottatech.frs.io.nio.HeaderException;
import com.terracottatech.frs.io.nio.NIOSegmentList;
import com.terracottatech.frs.io.nio.NIOStreamImpl;
import com.terracottatech.frs.io.nio.ReadOnlySegment;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NIORandomAccess
implements RandomAccess,
Closeable {
    private final NIOStreamImpl stream;
    private final NIOSegmentList segments;
    private final NavigableMap<Long, Integer> fileIndex;
    private volatile FileCache cache;
    private int maxFiles = Integer.MAX_VALUE;
    private final BufferSource src;
    private static final Logger LOGGER = LoggerFactory.getLogger(NIORandomAccess.class);

    NIORandomAccess(NIOStreamImpl stream, NIOSegmentList segments, BufferSource src) {
        this.stream = stream;
        this.segments = segments;
        this.fileIndex = new ConcurrentSkipListMap<Long, Integer>();
        this.cache = new FileCache(segments.getBeginningSegmentId(), 0, new ReadOnlySegment[1]);
        this.src = src;
    }

    public void setMaxFiles(int size) {
        this.maxFiles = size;
    }

    void seedCache(FileCache cache) {
        this.cache = cache;
    }

    FileCache createCache(int offset, int length, ReadOnlySegment[] cache) {
        return new FileCache(offset, length, cache);
    }

    @Override
    public Chunk scan(long marker) throws IOException {
        int segId;
        Map.Entry<Long, Integer> cacheId = this.fileIndex.floorEntry(marker);
        int startId = segId = cacheId != null ? cacheId.getValue().intValue() : this.cache.getOffset();
        Chunk c = null;
        while (c == null) {
            ReadOnlySegment seg = this.findSegment(segId);
            if (seg == null) {
                return null;
            }
            if (marker < seg.load(this.src).getBaseMarker()) {
                LOGGER.info("overshoot: " + marker + " < " + seg + " " + startId + " " + cacheId + " " + segId + " " + this.cache.getOffset() + " " + this.fileIndex);
                return null;
            }
            boolean segComplete = seg.isComplete();
            c = seg.scan(marker);
            if (c != null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(marker + " " + seg);
            }
            if (segComplete) {
                if (marker <= seg.getMaximumMarker()) continue;
                ++segId;
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            if (this.segments.getCount() + this.segments.getBeginningSegmentId() != seg.getSegmentId()) {
                throw new AssertionError();
            }
            LOGGER.debug("not advanced " + segId);
        }
        return c;
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    private ReadOnlySegment findSegment(int segNo) throws IOException {
        ReadOnlySegment ro = this.cache.findSegment(segNo);
        if (ro == null) {
            ro = this.createSegment(segNo);
        }
        if (ro != null && ro.getSegmentId() != segNo) {
            throw new AssertionError();
        }
        return ro;
    }

    ReadOnlySegment seek(long marker) throws IOException {
        Map.Entry<Long, Integer> cacheId = this.fileIndex.floorEntry(marker);
        int segId = cacheId != null ? cacheId.getValue().intValue() : this.segments.getBeginningSegmentId();
        ReadOnlySegment seg = null;
        while (seg == null) {
            int getId;
            if ((seg = this.findSegment(getId = segId++)) == null) {
                return null;
            }
            seg.load(this.src);
            if (seg.getMaximumMarker() >= marker) break;
            seg = null;
        }
        return seg;
    }

    synchronized void closeToReadHead() throws IOException {
        int current = this.segments.getSegmentPosition();
        this.cache = this.cache.closeSegments(current);
    }

    private void cleanCache() throws IOException {
        int fid = this.segments.getBeginningSegmentId();
        Map.Entry<Long, Integer> first = this.fileIndex.firstEntry();
        while (first != null && fid > first.getValue()) {
            this.fileIndex.remove(first.getKey());
            first = this.fileIndex.firstEntry();
        }
        this.cache = this.cache.removeSegments(fid);
    }

    void hint(long marker, int segment) {
        this.fileIndex.put(marker, segment);
    }

    private synchronized ReadOnlySegment createSegment(int segId) throws IOException {
        ReadOnlySegment seg = this.cache.findSegment(segId);
        if (seg == null) {
            this.cleanCache();
            try {
                File f = this.segments.getFile(segId);
                if (f == null) {
                    return null;
                }
                seg = new ReadOnlySegment(this.stream, this.stream.getAccessMethod(), f, Direction.RANDOM);
                this.cache = this.cache.addSegment(seg);
            }
            catch (HeaderException header) {
                throw new IOException(header);
            }
        }
        return seg;
    }

    class FileCache
    implements Closeable {
        private final int offset;
        private int livecount = 0;
        private final ReadOnlySegment[] segments;

        FileCache(int offset, int live, ReadOnlySegment[] segments) {
            this.offset = offset;
            this.livecount = live;
            this.segments = segments;
            for (int x = 0; x < segments.length; ++x) {
                if (segments[x] != null && segments[x].getSegmentId() != offset + x) {
                    throw new AssertionError();
                }
            }
        }

        public ReadOnlySegment findSegment(int segno) {
            int pos = segno - this.offset;
            if (pos >= this.segments.length) {
                return null;
            }
            ReadOnlySegment ro = this.segments[pos];
            if (ro != null && ro.getSegmentId() != segno) {
                throw new AssertionError((Object)(segno + " " + this.segments[pos].getSegmentId()));
            }
            return ro;
        }

        public int getOffset() {
            return this.offset;
        }

        public FileCache removeSegments(int limit) throws IOException {
            if (limit <= this.offset) {
                return this;
            }
            if (limit > this.offset + this.segments.length) {
                limit = this.offset + this.segments.length;
            }
            int x = 0;
            while (x + this.offset < limit) {
                if (this.segments[x] != null) {
                    this.segments[x].close();
                    this.segments[x] = null;
                    --this.livecount;
                }
                ++x;
            }
            return new FileCache(limit, this.livecount, Arrays.copyOfRange(this.segments, x, this.segments.length + 1));
        }

        public FileCache closeSegments(int limit) throws IOException {
            if (limit <= this.offset) {
                return this;
            }
            if (limit > this.offset + this.segments.length) {
                limit = this.offset + this.segments.length;
            }
            int x = 0;
            while (x + this.offset < limit) {
                if (this.segments[x] != null) {
                    this.segments[x].close();
                    this.segments[x] = null;
                    --this.livecount;
                }
                ++x;
            }
            return this;
        }

        public FileCache addSegment(ReadOnlySegment ro) throws IOException {
            if (ro.getSegmentId() < this.offset) {
                throw new AssertionError((Object)(ro.getSegmentId() + " " + this.offset));
            }
            if (this.livecount++ > NIORandomAccess.this.maxFiles) {
                for (int k = 0; k < this.segments.length; ++k) {
                    if (this.segments[k] == null) continue;
                    this.segments[k].close();
                    this.segments[k] = null;
                    --this.livecount;
                    break;
                }
            }
            if (this.segments.length <= ro.getSegmentId() - this.offset) {
                ReadOnlySegment[] na = Arrays.copyOf(this.segments, ro.getSegmentId() - this.offset + this.segments.length + 1);
                na[ro.getSegmentId() - this.offset] = ro;
                return new FileCache(this.offset, this.livecount, na);
            }
            this.segments[ro.getSegmentId() - this.offset] = ro;
            return this;
        }

        @Override
        public void close() throws IOException {
            for (ReadOnlySegment ro : this.segments) {
                if (ro == null) continue;
                ro.close();
            }
        }
    }
}

