/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.AbstractChunk;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class AppendableChunk
extends AbstractChunk {
    private ByteBuffer[] buffers;

    public AppendableChunk(List<ByteBuffer> base) {
        this.buffers = base.toArray(new ByteBuffer[base.size()]);
    }

    public AppendableChunk(ByteBuffer[] base) {
        this.buffers = base;
    }

    public AppendableChunk copy() {
        ByteBuffer[] cb = Arrays.copyOf(this.buffers, this.buffers.length);
        for (int x = 0; x < cb.length; ++x) {
            cb[x] = (ByteBuffer)cb[x].duplicate().clear();
        }
        return new AppendableChunk(cb);
    }

    public void append(ByteBuffer add) {
        ByteBuffer[] list = Arrays.copyOf(this.buffers, this.buffers.length + 1);
        list[this.buffers.length] = add;
        this.buffers = list;
    }

    @Override
    public ByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public void truncate(long position) {
        long len = 0L;
        for (int x = 0; x < this.buffers.length; ++x) {
            len += (long)this.buffers[x].limit();
            if (this.buffers[x].capacity() != this.buffers[x].limit()) {
                throw new AssertionError((Object)"bad truncation");
            }
            if (len > position) {
                this.buffers[x].position(this.buffers[x].limit() - (int)(len - position));
                this.buffers[x].flip();
                this.buffers[x] = this.buffers[x].slice();
                this.buffers[x].position(this.buffers[x].limit());
                if (x + 1 != this.buffers.length) {
                    this.buffers = Arrays.copyOf(this.buffers, x + 1);
                }
                if (this.hasRemaining()) {
                    throw new AssertionError((Object)"bad truncation");
                }
                return;
            }
            this.buffers[x].position(this.buffers[x].limit());
        }
    }

    public void destroy() {
        this.buffers = new ByteBuffer[0];
    }

    public void mark() {
        for (ByteBuffer bb : this.buffers) {
            if (!bb.hasRemaining()) continue;
            bb.mark();
            return;
        }
    }

    public void reset() {
        for (ByteBuffer bb : this.buffers) {
            if (!bb.hasRemaining()) continue;
            bb.reset();
            return;
        }
    }
}

