/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.action;

import com.terracottatech.frs.DisposableLifecycle;
import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionCodec;
import com.terracottatech.frs.action.ActionManager;
import com.terracottatech.frs.action.NullAction;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.log.LogRecordFactory;
import com.terracottatech.frs.object.ObjectManager;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ActionManagerImpl
implements ActionManager {
    private final LogManager logManager;
    private final ObjectManager<?, ?, ?> objectManager;
    private final ActionCodec actionCodec;
    private final LogRecordFactory logRecordFactory;
    private final AtomicInteger happeningCount;
    private volatile State happenState;
    private final ReentrantLock stateLock;
    private final Condition happenedCondition;
    private final Condition resumeCondition;

    public ActionManagerImpl(LogManager logManager, ObjectManager<?, ?, ?> objectManager, ActionCodec actionCodec, LogRecordFactory logRecordFactory) {
        this.logManager = logManager;
        this.objectManager = objectManager;
        this.actionCodec = actionCodec;
        this.logRecordFactory = logRecordFactory;
        this.happeningCount = new AtomicInteger(0);
        this.happenState = State.NORMAL;
        this.stateLock = new ReentrantLock();
        this.happenedCondition = this.stateLock.newCondition();
        this.resumeCondition = this.stateLock.newCondition();
    }

    private LogRecord wrapAction(Action action) {
        ByteBuffer[] payload = this.actionCodec.encode(action);
        return this.logRecordFactory.createLogRecord(payload, action);
    }

    @Override
    public Future<Void> syncHappened(Action action) {
        this.enterHappened();
        try {
            Future<Void> future = this.logManager.appendAndSync(this.wrapAction(action));
            return future;
        }
        finally {
            this.exitHappened();
        }
    }

    @Override
    public Future<Void> happened(Action action) {
        this.enterHappened();
        try {
            Future<Void> future = this.logManager.append(this.wrapAction(action));
            return future;
        }
        finally {
            this.exitHappened();
        }
    }

    @Override
    public Action extract(LogRecord record) {
        Action a = this.actionCodec.decode(record.getPayload());
        if (a instanceof DisposableLifecycle) {
            ((DisposableLifecycle)((Object)a)).setDisposable(record);
        }
        return a;
    }

    @Override
    public void pause() {
        this.stateLock.lock();
        try {
            if (this.happenState != State.NORMAL) {
                return;
            }
            this.happenState = State.WAITING_TO_PAUSE;
            if (this.happeningCount.get() == 0) {
                this.happenState = State.PAUSED;
            } else {
                boolean interrupted = false;
                while (this.happeningCount.get() != 0 && this.happenState == State.WAITING_TO_PAUSE) {
                    try {
                        this.happenedCondition.await();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                }
                if (this.happenState == State.WAITING_TO_PAUSE) {
                    this.happenState = State.PAUSED;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void resume() {
        this.stateLock.lock();
        try {
            if (this.happenState == State.NORMAL) {
                return;
            }
            this.happenState = State.NORMAL;
            this.happenedCondition.signal();
            this.resumeCondition.signalAll();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public LogRecord barrierAction() {
        return this.wrapAction(new NullAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterHappened() {
        block12: {
            this.happeningCount.incrementAndGet();
            if (this.happenState != State.NORMAL) {
                this.stateLock.lock();
                try {
                    if (this.happenState == State.NORMAL) break block12;
                    int happenedCnt = this.happeningCount.decrementAndGet();
                    try {
                        if (happenedCnt == 0) {
                            this.happenedCondition.signal();
                        }
                        boolean interrupted = false;
                        while (this.happenState != State.NORMAL) {
                            try {
                                this.resumeCondition.await();
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                        }
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    finally {
                        this.happeningCount.incrementAndGet();
                    }
                }
                finally {
                    this.stateLock.unlock();
                }
            }
        }
    }

    private void exitHappened() {
        int numIn = this.happeningCount.decrementAndGet();
        if (this.happenState != State.NORMAL) {
            this.stateLock.lock();
            try {
                if (numIn == 0 && this.happenState == State.WAITING_TO_PAUSE) {
                    this.happenedCondition.signal();
                }
            }
            finally {
                this.stateLock.unlock();
            }
        }
    }

    private static enum State {
        NORMAL,
        WAITING_TO_PAUSE,
        PAUSED;

    }
}

