/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license.cli;

import java.util.Date;
import org.terracotta.license.AbstractLicenseResolverFactory;
import org.terracotta.license.EnterpriseLicenseResolverFactory;
import org.terracotta.license.License;
import org.terracotta.license.LicenseException;

public class CliLicenseChecker {
    private final boolean testingMode;
    private final StringBuilder testingLogs = new StringBuilder();
    private volatile boolean initialized;
    private License license;
    private final AbstractLicenseResolverFactory factory = new EnterpriseLicenseResolverFactory();

    public CliLicenseChecker(boolean testingMode) {
        this.testingMode = testingMode;
    }

    public static void main(String[] args) {
        new CliLicenseChecker(false).licenseCheck(args);
    }

    void licenseCheck(String[] args) {
        try {
            this.findAndValidateLicense(args);
        }
        catch (LicenseException le) {
            this.log("The license is not valid : " + le.getMessage());
            System.exit(255);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(255);
        }
    }

    void findAndValidateLicense(String[] args) throws Exception {
        this.assertValidLicense();
        if (args != null && args.length > 0) {
            for (String arg : args) {
                this.logNoNewLine("Checking the " + arg + " capability ...");
                this.verifyCapability(arg);
                this.log("found");
            }
        } else {
            this.log("No capabilities verified (you need to specify as program arguments, space separated)");
        }
        if (this.isCommercialLicense()) {
            this.log("The license is commercial.");
        } else {
            this.log("The license is NOT commercial.");
        }
    }

    private void log(String message) {
        if (!this.testingMode) {
            System.err.println(String.format(message, new Object[0]));
        } else {
            this.testingLogs.append(message).append("\n");
        }
    }

    private void logNoNewLine(String message) {
        if (!this.testingMode) {
            System.err.print(String.format(message, new Object[0]));
        } else {
            this.testingLogs.append(message);
        }
    }

    private synchronized void init() {
        this.license = this.factory.resolveLicense();
        this.initialized = true;
        if (this.license != null) {
            this.log("Terracotta license loaded from " + this.factory.getLicenseLocation() + "\n" + this.license.toString());
        }
    }

    private synchronized License getLicense() {
        if (!this.initialized) {
            this.init();
        }
        return this.license;
    }

    private void assertValidLicense() {
        boolean expiredOrMissing = false;
        String errorMessage = null;
        if (this.getLicense() == null) {
            expiredOrMissing = true;
            errorMessage = "No license could be found.";
        } else {
            Date expirationDate = this.getLicense().expirationDate();
            if (expirationDate != null && expirationDate.before(new Date())) {
                errorMessage = "Your Terracotta license has expired on " + expirationDate;
                expiredOrMissing = true;
            }
        }
        if (expiredOrMissing) {
            throw new LicenseException(errorMessage);
        }
    }

    private void verifyCapability(String capability) {
        if (!this.getLicense().isCapabilityEnabled(capability)) {
            throw new LicenseException("Your license key doesn't allow usage of '" + capability + "' capability");
        }
    }

    private boolean isCommercialLicense() {
        return this.getLicense().type().equals("Commercial");
    }

    public StringBuilder getTestingLogs() {
        return this.testingLogs;
    }
}

