/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.terracotta.ehcachedx.util.VmVersion;

public class Vm {
    public static final VmVersion VERSION = new VmVersion(System.getProperties());
    private static final Pattern MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN = Pattern.compile("\\s*-XX:MaxDirectMemorySize\\s*=\\s*([0-9]+)\\s*([kKmMgG]?)\\s*$");

    private Vm() {
    }

    public static boolean isAzul() {
        return VERSION.isAzul();
    }

    public static int dataModel() {
        try {
            if (Vm.isAzul()) {
                return 64;
            }
            String dataModelString = System.getProperty("sun.arch.data.model", "0");
            return Integer.parseInt(dataModelString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long maxDirectMemory() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        for (String vmArg : runtime.getInputArguments()) {
            Matcher m = MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN.matcher(vmArg);
            if (!m.matches()) continue;
            long maxDirectMemory = Long.parseLong(m.group(1));
            switch (m.group(2).charAt(0)) {
                case 'K': 
                case 'k': {
                    maxDirectMemory *= 1024L;
                    break;
                }
                case 'M': 
                case 'm': {
                    maxDirectMemory *= 0x100000L;
                    break;
                }
                case 'G': 
                case 'g': {
                    maxDirectMemory *= 0x40000000L;
                }
            }
            return maxDirectMemory;
        }
        return Long.MIN_VALUE;
    }
}

