/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.pool.impl;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.store.offheap.OffHeapStoreFactory;
import net.sf.ehcache.store.offheap.configuration.OffHeapConfiguration;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolEvictor;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolParticipant;
import net.sf.ehcache.store.offheap.pool.impl.OffHeapPoolAccessor;
import net.sf.ehcache.store.offheap.pool.impl.OffHeapPoolEvictorImpl;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.paging.UpfrontAllocatingPageSource;

public class OffHeapPoolImpl
implements OffHeapPool {
    private final OffHeapPoolEvictor evictor;
    private final Collection<PoolAccessor<OffHeapPoolParticipant>> accessors = new CopyOnWriteArrayList<PoolAccessor<OffHeapPoolParticipant>>();
    private final OffHeapConfiguration config;
    private final PageSource source;

    public OffHeapPoolImpl(OffHeapConfiguration config) {
        this(config, new OffHeapPoolEvictorImpl(config.getMaximumSize()));
    }

    public OffHeapPoolImpl(OffHeapConfiguration config, OffHeapPoolEvictor evictor) {
        this.config = config;
        this.evictor = evictor;
        this.source = new UpfrontAllocatingPageSource(OffHeapStoreFactory.getBufferSource(), config.getMaximumSize(), config.getMaximumChunkSize(), config.getMinimumChunkSize());
    }

    @Override
    public Collection<PoolAccessor<OffHeapPoolParticipant>> getPoolAccessors() {
        return this.accessors;
    }

    @Override
    public void registerParticipant(OffHeapPoolParticipant offHeapPoolParticipant) {
        this.accessors.add(new OffHeapPoolAccessor(offHeapPoolParticipant));
    }

    @Override
    public PageSource getPageSource() {
        return this.source;
    }

    @Override
    public OffHeapConfiguration getPoolConfiguration() {
        return this.config;
    }

    @Override
    public OffHeapPoolEvictor getEvictor() {
        return this.evictor;
    }
}

