/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolParticipant;
import net.sf.ehcache.pool.impl.AbstractPoolAccessor;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStore;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStoreSizeOfEngine;

public final class OffHeapDiskStorePoolAccessor
extends AbstractPoolAccessor {
    private final OffHeapDiskStore offHeapDiskStore;

    OffHeapDiskStorePoolAccessor(Pool pool, PoolParticipant participant, OffHeapDiskStore store) {
        super(pool, participant, new OffHeapDiskStoreSizeOfEngine());
        this.offHeapDiskStore = store;
    }

    @Override
    protected long add(long sizeOf, boolean force) throws IllegalArgumentException {
        long maxSize;
        this.checkLinked();
        if (sizeOf < 0L) {
            throw new IllegalArgumentException("cannot add negative size");
        }
        long newSize = this.getPool().getSize() + sizeOf;
        if (newSize <= (maxSize = this.getPool().getMaxSize())) {
            return sizeOf;
        }
        if (!force && sizeOf > maxSize) {
            return -1L;
        }
        long missingSize = newSize - maxSize;
        if (this.getPool().getEvictor().freeSpace(this.getPool().getPoolAccessors(), missingSize) || force) {
            return sizeOf;
        }
        return -1L;
    }

    @Override
    protected boolean canAddWithoutEvicting(long sizeOf) {
        return this.getPool().getSize() + sizeOf <= this.getPool().getMaxSize();
    }

    @Override
    public long delete(long sizeOf) throws IllegalArgumentException {
        this.checkLinked();
        if (sizeOf < 0L) {
            throw new IllegalArgumentException("cannot delete negative size");
        }
        return sizeOf;
    }

    @Override
    public long getSize() {
        return this.offHeapDiskStore.getOccupiedMemory();
    }

    @Override
    protected void doClear() {
    }
}

