/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.store;

import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.shaded.lucene.store.Lock;
import org.terracotta.shaded.lucene.store.LockFactory;

public class ConcurrentLockFactory
extends LockFactory {
    private final ConcurrentHashMap<String, String> locks = new ConcurrentHashMap();

    @Override
    public Lock makeLock(String lockName) {
        return new LockObject(this.locks, lockName);
    }

    @Override
    public void clearLock(String lockName) {
        this.locks.remove(lockName);
    }

    private static final class LockObject
    extends Lock {
        String lockName;
        private final ConcurrentHashMap<String, String> locks;

        public LockObject(ConcurrentHashMap<String, String> locks2, String lockName) {
            this.locks = locks2;
            this.lockName = lockName;
        }

        @Override
        public boolean obtain() {
            return this.locks.putIfAbsent(this.lockName, this.lockName) == null;
        }

        @Override
        public void release() {
            this.locks.remove(this.lockName);
        }

        @Override
        public boolean isLocked() {
            return this.locks.containsKey(this.lockName);
        }

        public String toString() {
            return super.toString() + ": " + this.lockName;
        }
    }
}

