/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.terracotta.shaded.lucene.index.IndexCommit;
import org.terracotta.shaded.lucene.index.IndexDeletionPolicy;

public class ExplicitBlockingDeletePolicy
extends IndexDeletionPolicy {
    private final CounterLock clock;
    private final IndexDeletionPolicy delegate;
    private LinkedBlockingQueue<IndexCommit> q = new LinkedBlockingQueue();

    public ExplicitBlockingDeletePolicy(IndexDeletionPolicy delegate) {
        this.clock = new CounterLock();
        this.delegate = delegate;
    }

    public ExplicitBlockingDeletePolicy(CounterLock clock, IndexDeletionPolicy delegate) {
        this.clock = clock;
        this.delegate = delegate;
    }

    @Override
    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        if (!commits.isEmpty()) {
            if (this.clock.sharedLock()) {
                try {
                    IndexCommit ic = this.q.poll();
                    while (ic != null) {
                        ic.delete();
                        ic = this.q.poll();
                    }
                    this.delegate.onCommit(commits);
                }
                finally {
                    this.clock.sharedUnlock();
                }
            } else {
                for (IndexCommit indexCommit : commits) {
                    this.q.add(indexCommit);
                }
            }
        }
    }

    @Override
    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        this.onCommit(commits);
    }

    public void pinDeletions() {
        this.clock.lockExclusively();
    }

    public void unpinDeletions() {
        this.clock.unlockExclusively();
    }

    @Override
    public IndexDeletionPolicy clone() {
        return new ExplicitBlockingDeletePolicy(this.clock, this.delegate.clone());
    }

    static class CounterLock {
        private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock(true);
        private volatile int counter = 0;

        CounterLock() {
        }

        void lockExclusively() {
            this.rwlock.writeLock().lock();
            try {
                ++this.counter;
            }
            finally {
                this.rwlock.writeLock().unlock();
            }
        }

        void unlockExclusively() {
            this.rwlock.writeLock().lock();
            try {
                --this.counter;
                if (this.counter < 0) {
                    throw new AssertionError();
                }
            }
            finally {
                this.rwlock.writeLock().unlock();
            }
        }

        public boolean sharedLock() {
            if (this.rwlock.readLock().tryLock()) {
                if (this.counter == 0) {
                    return true;
                }
                this.rwlock.readLock().unlock();
            }
            return false;
        }

        public void sharedUnlock() {
            this.rwlock.readLock().unlock();
        }
    }
}

