/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable;

import com.terracottatech.frs.NotPausedException;
import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.RestartStoreException;
import com.terracottatech.frs.Snapshot;
import com.terracottatech.frs.Statistics;
import com.terracottatech.frs.Transaction;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.Tuple;
import com.terracottatech.frs.recovery.RecoveryException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.terracotta.offheapstore.util.FindbugsSuppressWarnings;

public class RestartStoreReentrantReadWriteLock<I, K, V>
extends ReentrantReadWriteLock {
    private static final long serialVersionUID = -1119986092399074087L;
    private final LockScopedRestartStore<I, K, V> txnWriteLock;

    public RestartStoreReentrantReadWriteLock(RestartStore<I, K, V> restartability) {
        this.txnWriteLock = new LockScopedRestartStore<I, K, V>(restartability, this);
    }

    @Override
    public LockScopedRestartStore<I, K, V> writeLock() {
        return this.txnWriteLock;
    }

    static class WrappedTransaction<I, K, V>
    implements Transaction<I, K, V> {
        private Transaction<I, K, V> delegate;

        public WrappedTransaction(Transaction<I, K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Transaction<I, K, V> put(I id, K key, V value) throws TransactionException {
            this.delegate = this.delegate.put(id, key, value);
            return this;
        }

        @Override
        public Transaction<I, K, V> delete(I id) throws TransactionException {
            this.delegate = this.delegate.delete(id);
            return this;
        }

        @Override
        public Transaction<I, K, V> remove(I id, K key) throws TransactionException {
            this.delegate = this.delegate.remove(id, key);
            return this;
        }

        @Override
        public void commit() throws TransactionException {
        }
    }

    static class LockScopedRestartStore<I, K, V>
    extends ReentrantReadWriteLock.WriteLock
    implements RestartStore<I, K, V> {
        private static final long serialVersionUID = 1126153721546674833L;
        private final RestartStore<I, K, V> restartability;
        @FindbugsSuppressWarnings(value={"SE_BAD_FIELD"})
        private final ThreadLocal<WrappedTransaction<I, K, V>> transaction = new ThreadLocal();

        protected LockScopedRestartStore(RestartStore<I, K, V> restartability, ReentrantReadWriteLock rrwl) {
            super(rrwl);
            this.restartability = restartability;
        }

        @Override
        public Future<Void> startup() throws InterruptedException, RecoveryException {
            return this.restartability.startup();
        }

        @Override
        public Snapshot snapshot() throws RestartStoreException {
            return this.restartability.snapshot();
        }

        @Override
        public void unlock() {
            super.unlock();
            WrappedTransaction<I, K, V> txn = this.transaction.get();
            if (txn == null) {
                this.transaction.remove();
            } else if (!this.isHeldByCurrentThread()) {
                this.transaction.remove();
                try {
                    ((WrappedTransaction)txn).delegate.commit();
                }
                catch (TransactionException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public Transaction<I, K, V> beginTransaction(boolean synchronous) {
            if (this.isHeldByCurrentThread()) {
                WrappedTransaction<I, K, V> active = this.transaction.get();
                if (active == null) {
                    active = new WrappedTransaction<I, K, V>(this.restartability.beginTransaction(synchronous));
                    this.transaction.set(active);
                }
                return active;
            }
            throw new IllegalStateException();
        }

        @Override
        public Transaction<I, K, V> beginAutoCommitTransaction(boolean synchronous) {
            return this.restartability.beginAutoCommitTransaction(synchronous);
        }

        @Override
        public void shutdown() throws InterruptedException {
            this.restartability.shutdown();
        }

        @Override
        public Tuple<I, K, V> get(long marker) {
            return this.restartability.get(marker);
        }

        @Override
        public Statistics getStatistics() {
            return this.restartability.getStatistics();
        }

        @Override
        public Future<Future<Snapshot>> pause() {
            return this.restartability.pause();
        }

        @Override
        public void resume() throws NotPausedException {
            this.restartability.resume();
        }

        @Override
        public Future<Future<Void>> freeze() {
            return this.restartability.freeze();
        }
    }
}

