/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import org.terracotta.shaded.lucene.search.DisjunctionScorer;
import org.terracotta.shaded.lucene.search.Scorer;
import org.terracotta.shaded.lucene.search.Weight;

class DisjunctionMaxScorer
extends DisjunctionScorer {
    private final float tieBreakerMultiplier;
    private int freq = -1;
    private float scoreSum;
    private float scoreMax;

    public DisjunctionMaxScorer(Weight weight, float tieBreakerMultiplier, Scorer[] subScorers) {
        super(weight, subScorers);
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    @Override
    public float score() throws IOException {
        return this.scoreMax + (this.scoreSum - this.scoreMax) * this.tieBreakerMultiplier;
    }

    @Override
    protected void afterNext() throws IOException {
        this.doc = this.subScorers[0].docID();
        if (this.doc != Integer.MAX_VALUE) {
            this.scoreSum = this.scoreMax = this.subScorers[0].score();
            this.freq = 1;
            this.scoreAll(1);
            this.scoreAll(2);
        }
    }

    private void scoreAll(int root) throws IOException {
        if (root < this.numScorers && this.subScorers[root].docID() == this.doc) {
            float sub = this.subScorers[root].score();
            ++this.freq;
            this.scoreSum += sub;
            this.scoreMax = Math.max(this.scoreMax, sub);
            this.scoreAll((root << 1) + 1);
            this.scoreAll((root << 1) + 2);
        }
    }

    @Override
    public int freq() throws IOException {
        return this.freq;
    }
}

