/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.writer.writebehind;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.writebehind.RestartableWriteBehindQueue;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import net.sf.ehcache.writer.writebehind.WriteBehindQueueManager;

public class RestartableWriteBehindQueueManager
extends WriteBehindQueueManager {
    private final EhcacheRestartability ehcacheRestartability;

    public RestartableWriteBehindQueueManager(CacheConfiguration config, EhcacheRestartability restartability) {
        super(config, new RestartableWriteBehindQueueFactory(restartability));
        this.ehcacheRestartability = restartability;
    }

    @Override
    public void start(final CacheWriter writer) throws CacheException {
        this.ehcacheRestartability.callbackOnStartupComplete(new Runnable(){

            @Override
            public void run() {
                RestartableWriteBehindQueueManager.super.start(writer);
            }
        });
    }

    protected static class RestartableWriteBehindQueueFactory
    extends WriteBehindQueueManager.WriteBehindQueueFactory {
        private final EhcacheRestartability restartability;

        public RestartableWriteBehindQueueFactory(EhcacheRestartability restartability) {
            this.restartability = restartability;
        }

        @Override
        protected WriteBehind createQueue(int index, CacheConfiguration config) {
            return new RestartableWriteBehindQueue(config, index, this.restartability);
        }
    }
}

