/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.restartability;

import com.terracottatech.offheapstore.storage.portability.Portability;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import net.sf.ehcache.store.restartability.EhcacheRestartableMap;
import net.sf.ehcache.transaction.AbstractSoftLockManager;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.SoftLockID;

public class RestartableSoftLockManager
extends AbstractSoftLockManager {
    private final ConcurrentMap<SoftLockID, SoftLock> allLocks;
    private final ConcurrentMap<SoftLockID, Boolean> newKeyLocks;

    public RestartableSoftLockManager(String cacheName, SoftLockFactory lockFactory, EhcacheRestartability restartability) {
        super(cacheName, lockFactory);
        this.allLocks = new RestartableSoftLockMap(cacheName, lockFactory, restartability);
        this.newKeyLocks = new ConcurrentHashMap<SoftLockID, Boolean>();
    }

    @Override
    protected ConcurrentMap<SoftLockID, SoftLock> getAllLocks() {
        return this.allLocks;
    }

    @Override
    protected ConcurrentMap<SoftLockID, Boolean> getNewKeyLocks() {
        return this.newKeyLocks;
    }

    class RestartableSoftLockMap
    extends EhcacheRestartableMap<SoftLockID, SoftLock, ByteBuffer, ByteBuffer, ByteBuffer> {
        private final SoftLockFactory lockFactory;
        private final Portability<? super Serializable> portability;

        RestartableSoftLockMap(String cacheName, SoftLockFactory lockFactory, EhcacheRestartability restartability) {
            super(EhcacheRestartability.getSoftLockIdentifier(cacheName), restartability.getCacheStore());
            this.portability = restartability.getRestartablePortability();
            this.lockFactory = lockFactory;
            restartability.registerRestartableCacheObject(this);
        }

        @Override
        protected void replayPut(SoftLockID key, SoftLock value) {
            super.replayPut(key, value);
            if (key.getOldElement() == null) {
                RestartableSoftLockManager.this.getNewKeyLocks().put(key, Boolean.TRUE);
            }
        }

        @Override
        protected ByteBuffer encodeKey(SoftLockID key) {
            return this.portability.encode(key);
        }

        @Override
        protected ByteBuffer encodeValue(SoftLock value) {
            return this.portability.encode((Serializable)value.getKey());
        }

        @Override
        protected SoftLockID decodeKey(ByteBuffer rKey) {
            return (SoftLockID)this.portability.decode(rKey.duplicate());
        }

        @Override
        protected SoftLock decodeValue(ByteBuffer rValue) {
            return this.lockFactory.newSoftLock(RestartableSoftLockManager.this, this.portability.decode(rValue.duplicate()));
        }

        @Override
        protected long keyByteSize(SoftLockID key, ByteBuffer encodedKey) {
            return encodedKey.capacity();
        }

        @Override
        protected long valueByteSize(SoftLock value, ByteBuffer encodedValue) {
            return encodedValue.capacity();
        }
    }
}

