/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.storage.FileBackedStorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.CacheOperationOutcomes;
import net.sf.ehcache.DiskStorePathManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.statistics.StatisticBuilder;
import net.sf.ehcache.store.offheap.configuration.ExplicitDiskConfiguration;
import net.sf.ehcache.store.offheap.disk.DiskWriteThreadPool;
import net.sf.ehcache.store.offheap.disk.EhcachePersistentConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStore;
import net.sf.ehcache.store.offheap.disk.persistent.OffHeapPersistentDiskStore;
import net.sf.ehcache.store.offheap.portability.PersistentEhcacheElementPortability;
import net.sf.ehcache.store.offheap.portability.PersistentEhcacheKeyPortability;
import net.sf.ehcache.store.offheap.search.LuceneIndexedSearchManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.statistics.observer.OperationObserver;

public class OffHeapDiskStoreFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapDiskStoreFactory.class);

    public static OffHeapDiskStore create(Cache cache, Pool onDiskPool, LuceneIndexedSearchManager searchManager) {
        EhcachePersistentConcurrentOffHeapClockCache map;
        File dataFile;
        CacheManager manager = cache.getCacheManager();
        if (manager == null) {
            throw new CacheException(cache.getName() + " Cache: Could not create disk store. " + "Cache must belong to a cache manager to create diskstore.");
        }
        OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.EvictionOutcome.class).of(cache)).named("eviction")).build();
        CacheConfiguration config = cache.getCacheConfiguration();
        try {
            dataFile = manager.getDiskStorePathManager().getFile(cache.getName(), ".data");
            dataFile.deleteOnExit();
            ExplicitDiskConfiguration diskConfig = ExplicitDiskConfiguration.createFor(cache.getName());
            map = OffHeapDiskStoreFactory.createBackingMap(dataFile, cache.getCacheEventNotificationService(), evictionObserver, config, diskConfig, searchManager);
        }
        catch (IOException e) {
            throw new CacheException("Failed to create disk store", e);
        }
        return new OffHeapDiskStore(dataFile, map, cache.getCacheEventNotificationService(), onDiskPool, cache, searchManager);
    }

    public static OffHeapPersistentDiskStore createPersistent(Ehcache cache, Pool onDiskPool, LuceneIndexedSearchManager searchManager) {
        CacheManager manager = cache.getCacheManager();
        if (manager == null) {
            throw new CacheException(cache.getName() + " Cache: Could not create disk store. " + "Cache must belong to a cache manager to create diskstore.");
        }
        OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.EvictionOutcome.class).of(cache)).named("eviction")).build();
        DiskStorePathManager diskStorePathManager = manager.getDiskStorePathManager();
        File dataFile = diskStorePathManager.getFile(cache.getName(), ".data");
        File indexFile = diskStorePathManager.getFile(cache.getName(), ".index");
        try {
            ExplicitDiskConfiguration diskConfig = ExplicitDiskConfiguration.createFor(cache.getName());
            if (diskStorePathManager.isAutoCreated()) {
                LOGGER.warn("Data in persistent disk stores is ignored for stores from automatically created directories.\nRemove the persistence configuration or resolve the conflicting disk paths in cache configuration.\nDeleting data file " + dataFile.getAbsolutePath());
                return OffHeapDiskStoreFactory.createNewPersistent(cache, dataFile, indexFile, onDiskPool, diskConfig, evictionObserver, searchManager);
            }
            if (dataFile.isFile() && indexFile.isFile()) {
                return OffHeapDiskStoreFactory.recoverExistingPersistent(cache, dataFile, indexFile, onDiskPool, diskConfig, evictionObserver, searchManager);
            }
            LOGGER.debug("Missing data and/or index file for {}.  Creating a new empty store.", (Object)cache.getName());
            return OffHeapDiskStoreFactory.createNewPersistent(cache, dataFile, indexFile, onDiskPool, diskConfig, evictionObserver, searchManager);
        }
        catch (IOException e) {
            throw new CacheException("Failed to create disk store", e);
        }
    }

    private static OffHeapPersistentDiskStore createNewPersistent(Ehcache cache, File dataFile, File indexFile, Pool onDiskPool, ExplicitDiskConfiguration diskConfig, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, LuceneIndexedSearchManager searchManager) throws IOException {
        CacheConfiguration config = cache.getCacheConfiguration();
        EhcachePersistentConcurrentOffHeapClockCache map = OffHeapDiskStoreFactory.createBackingMap(dataFile, cache.getCacheEventNotificationService(), evictionObserver, config, diskConfig, searchManager);
        OffHeapPersistentDiskStore offHeapPersistentDiskStore = new OffHeapPersistentDiskStore(dataFile, indexFile, map, cache.getCacheEventNotificationService(), onDiskPool, cache, searchManager);
        if (onDiskPool.getSize() >= 0L) {
            List<?> keys = offHeapPersistentDiskStore.getKeys();
            for (Object key : keys) {
                Element value = offHeapPersistentDiskStore.getQuiet(key);
                offHeapPersistentDiskStore.put(new Element(key, (Object)value));
            }
        }
        return offHeapPersistentDiskStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OffHeapPersistentDiskStore recoverExistingPersistent(Ehcache cache, File dataFile, File indexFile, Pool onDiskPool, ExplicitDiskConfiguration diskConfig, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, LuceneIndexedSearchManager searchManager) throws IOException {
        FileInputStream fin = new FileInputStream(indexFile);
        try {
            ObjectInputStream input = new ObjectInputStream(fin);
            long dataTimestampFromIndex = input.readLong();
            long dataTimestampFromFile = dataFile.lastModified();
            long delta = dataTimestampFromFile - dataTimestampFromIndex;
            if (delta < 0L) {
                LOGGER.info("The index for data file {} is more recent than the data file itself by {}ms : this is harmless.", (Object)dataFile.getName(), (Object)(-delta));
            } else {
                if (delta > TimeUnit.SECONDS.toMillis(1L)) {
                    LOGGER.warn("The index for data file {} is out of date by {}ms, probably due to an unclean shutdown. Creating a new empty store.", (Object)dataFile.getName(), (Object)delta);
                    OffHeapPersistentDiskStore offHeapPersistentDiskStore = OffHeapDiskStoreFactory.createNewPersistent(cache, dataFile, indexFile, onDiskPool, diskConfig, evictionObserver, searchManager);
                    return offHeapPersistentDiskStore;
                }
                if (delta > 0L) {
                    LOGGER.info("The index for data file {} is out of date by {}ms, assuming this small delta is a result of the OS/filesystem.", (Object)dataFile.getName(), (Object)delta);
                }
            }
            CacheConfiguration config = cache.getCacheConfiguration();
            EhcachePersistentConcurrentOffHeapClockCache map = OffHeapDiskStoreFactory.recoverBackingMap(input, dataFile, cache.getCacheEventNotificationService(), evictionObserver, config, diskConfig, searchManager);
            OffHeapPersistentDiskStore offHeapPersistentDiskStore = new OffHeapPersistentDiskStore(dataFile, indexFile, map, cache.getCacheEventNotificationService(), onDiskPool, cache, searchManager);
            return offHeapPersistentDiskStore;
        }
        catch (Exception e) {
            LOGGER.info("Index file was corrupt. Deleting data file " + dataFile.getAbsolutePath() + ". " + e.getMessage());
            LOGGER.debug("Exception during recovery", (Throwable)e);
            OffHeapPersistentDiskStore offHeapPersistentDiskStore = OffHeapDiskStoreFactory.createNewPersistent(cache, dataFile, indexFile, onDiskPool, diskConfig, evictionObserver, searchManager);
            return offHeapPersistentDiskStore;
        }
        finally {
            fin.close();
        }
    }

    public static EhcachePersistentConcurrentOffHeapClockCache createBackingMap(File dataFile, RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, CacheConfiguration cacheConfig, ExplicitDiskConfiguration diskConfig, LuceneIndexedSearchManager searchManager) throws IOException {
        LOGGER.info("Creating On Disk Area Using Config\n {}", (Object)diskConfig);
        MappedPageSource source = new MappedPageSource(dataFile);
        DiskWriteThreadPool writeWorkers = new DiskWriteThreadPool(cacheConfig.getName(), Math.min(diskConfig.getConcurrency(), cacheConfig.getDiskAccessStripes()));
        PersistentEhcacheKeyPortability keyPortability = new PersistentEhcacheKeyPortability(cacheConfig);
        Factory<FileBackedStorageEngine<Serializable, Element>> storageEngineFactory = FileBackedStorageEngine.createFactory(source, diskConfig.getSegmentDataPageSize(), keyPortability, new PersistentEhcacheElementPortability(cacheConfig), writeWorkers, true);
        if (searchManager != null) {
            searchManager.destroy(cacheConfig.getName());
            storageEngineFactory = searchManager.newSearchStorageEngineListeningFactory(storageEngineFactory, keyPortability, cacheConfig);
        }
        return new EhcachePersistentConcurrentOffHeapClockCache(evictionListener, evictionObserver, cacheConfig, source, writeWorkers, storageEngineFactory, diskConfig.getInitialSegmentTableSize(), diskConfig.getConcurrency());
    }

    public static EhcachePersistentConcurrentOffHeapClockCache recoverBackingMap(ObjectInput input, File dataFile, RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, CacheConfiguration cacheConfig, ExplicitDiskConfiguration diskConfig, LuceneIndexedSearchManager searchManager) throws IOException {
        MappedPageSource source = new MappedPageSource(dataFile, false);
        try {
            DiskWriteThreadPool writeWorkers = new DiskWriteThreadPool(cacheConfig.getName(), Math.min(diskConfig.getConcurrency(), cacheConfig.getDiskAccessStripes()));
            PersistentEhcacheKeyPortability keyPortability = new PersistentEhcacheKeyPortability(cacheConfig);
            Factory<FileBackedStorageEngine<Serializable, Element>> storageEngineFactory = FileBackedStorageEngine.createFactory(source, diskConfig.getSegmentDataPageSize(), keyPortability, new PersistentEhcacheElementPortability(cacheConfig), writeWorkers, false);
            if (searchManager != null) {
                searchManager.destroy(cacheConfig.getName(), true);
                storageEngineFactory = searchManager.newSearchStorageEngineListeningFactory(storageEngineFactory, keyPortability, cacheConfig);
            }
            EhcachePersistentConcurrentOffHeapClockCache map = new EhcachePersistentConcurrentOffHeapClockCache(input, evictionListener, evictionObserver, cacheConfig, source, writeWorkers, storageEngineFactory, diskConfig.getInitialSegmentTableSize());
            map.bootstrap(input);
            return map;
        }
        catch (IOException e) {
            source.close();
            throw e;
        }
    }
}

