/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.cachingtier;

import com.terracottatech.offheapstore.eviction.EvictionListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.ehcache.store.CachingTier;

public final class CachingTierEvictionListener<K, V>
implements EvictionListener<K, V> {
    private final List<CachingTier.Listener<K, V>> listeners;

    public CachingTierEvictionListener() {
        this(new CopyOnWriteArrayList<CachingTier.Listener<K, V>>());
    }

    public CachingTierEvictionListener(List<CachingTier.Listener<K, V>> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void evicting(Callable<Map.Entry<K, V>> callable) {
        Map.Entry<K, V> entry;
        try {
            entry = callable.call();
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        for (CachingTier.Listener<K, V> listener : this.listeners) {
            listener.evicted(entry.getKey(), entry.getValue());
        }
    }

    public List<CachingTier.Listener<K, V>> getListeners() {
        return this.listeners;
    }
}

