/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.pool.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.pool.PoolEvictor;
import net.sf.ehcache.pool.SizeOfEngine;

public abstract class AbstractPool<T>
implements Pool<T> {
    private volatile long maximumPoolSize;
    private final PoolEvictor<T> evictor;
    private final List<PoolAccessor<? extends T>> poolAccessors;
    private final SizeOfEngine defaultSizeOfEngine;

    public AbstractPool(long maximumPoolSize, PoolEvictor<T> evictor, SizeOfEngine defaultSizeOfEngine) {
        this.maximumPoolSize = maximumPoolSize;
        this.evictor = evictor;
        this.defaultSizeOfEngine = defaultSizeOfEngine;
        this.poolAccessors = new CopyOnWriteArrayList<PoolAccessor<? extends T>>();
    }

    @Override
    public long getSize() {
        long total = 0L;
        for (PoolAccessor<T> poolAccessor : this.poolAccessors) {
            total += poolAccessor.getSize();
        }
        return total;
    }

    @Override
    public long getMaxSize() {
        return this.maximumPoolSize;
    }

    @Override
    public void setMaxSize(long newSize) {
        long oldSize = this.maximumPoolSize;
        this.maximumPoolSize = newSize;
        long sizeToEvict = oldSize - newSize;
        if (sizeToEvict > 0L) {
            this.evictor.freeSpace(this.getPoolableStores(), sizeToEvict);
        }
    }

    @Override
    public PoolAccessor<T> createPoolAccessor(T store, int maxDepth, boolean abortWhenMaxDepthExceeded) {
        return this.createPoolAccessor(store, this.defaultSizeOfEngine.copyWith(maxDepth, abortWhenMaxDepthExceeded));
    }

    @Override
    public void registerPoolAccessor(PoolAccessor<? extends T> accessor) {
        this.poolAccessors.add(accessor);
    }

    @Override
    public void removePoolAccessor(PoolAccessor accessor) {
        this.poolAccessors.remove(accessor);
    }

    @Override
    public Collection<T> getPoolableStores() {
        ArrayList<T> poolableStores = new ArrayList<T>(this.poolAccessors.size());
        for (PoolAccessor<T> poolAccessor : this.poolAccessors) {
            poolableStores.add(poolAccessor.getStore());
        }
        return poolableStores;
    }

    @Override
    public PoolEvictor<T> getEvictor() {
        return this.evictor;
    }
}

