/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.management.sampled.CacheSampler;
import net.sf.ehcache.management.sampled.Utils;
import net.sf.ehcache.util.CacheTransactionHelper;
import net.sf.ehcache.writer.writebehind.WriteBehindManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheSamplerImpl
implements CacheSampler,
CacheConfigurationListener {
    private static final int PERCENTAGE_DIVISOR = 100;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final Logger LOG = LoggerFactory.getLogger(CacheSamplerImpl.class);
    private final Ehcache cache;

    public CacheSamplerImpl(Ehcache cache) {
        this.cache = cache;
        cache.getCacheConfiguration().addConfigurationListener(this);
    }

    public boolean isEnabled() {
        return !this.cache.isDisabled();
    }

    public void setEnabled(boolean enabled) {
        try {
            this.cache.setDisabled(!enabled);
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public boolean isClusterBulkLoadEnabled() {
        try {
            return this.cache.isClusterBulkLoadEnabled();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public boolean isNodeBulkLoadEnabled() {
        return this.cache.isNodeBulkLoadEnabled();
    }

    public void setNodeBulkLoadEnabled(boolean bulkLoadEnabled) {
        if (bulkLoadEnabled && this.getTransactional()) {
            LOG.warn("a transactional cache cannot be put into bulk-load mode");
            return;
        }
        this.cache.setNodeBulkLoadEnabled(!bulkLoadEnabled);
    }

    public void flush() {
        try {
            this.cache.flush();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public String getCacheName() {
        return this.cache.getName();
    }

    public String getStatus() {
        return this.cache.getStatus().toString();
    }

    public void removeAll() {
        CacheTransactionHelper.beginTransactionIfNeeded(this.cache);
        try {
            this.cache.removeAll();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
        finally {
            try {
                CacheTransactionHelper.commitTransactionIfNeeded(this.cache);
            }
            catch (RuntimeException e2) {
                throw Utils.newPlainException(e2);
            }
        }
    }

    public long getAverageGetTimeMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getAverageGetTimeMostRecentSample();
    }

    public long getAverageGetTimeNanosMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getAverageGetTimeNanosMostRecentSample();
    }

    public long getCacheEvictionRate() {
        return this.getCacheElementEvictedMostRecentSample();
    }

    public long getCacheElementEvictedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementEvictedMostRecentSample();
    }

    public long getCacheExpirationRate() {
        return this.getCacheElementExpiredMostRecentSample();
    }

    public long getCacheElementExpiredMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementExpiredMostRecentSample();
    }

    public long getCachePutRate() {
        return this.getCacheElementPutMostRecentSample();
    }

    public long getCacheElementPutMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementPutMostRecentSample();
    }

    public long getCacheRemoveRate() {
        return this.getCacheElementRemovedMostRecentSample();
    }

    public long getCacheElementRemovedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementRemovedMostRecentSample();
    }

    public long getCacheUpdateRate() {
        return this.getCacheElementUpdatedMostRecentSample();
    }

    public long getCacheElementUpdatedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementUpdatedMostRecentSample();
    }

    public long getCacheInMemoryHitRate() {
        return this.getCacheHitInMemoryMostRecentSample();
    }

    public long getCacheHitInMemoryMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitInMemoryMostRecentSample();
    }

    public long getCacheOffHeapHitRate() {
        return this.getCacheHitOffHeapMostRecentSample();
    }

    public long getCacheHitOffHeapMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitOffHeapMostRecentSample();
    }

    public long getCacheHitRate() {
        return this.getCacheHitMostRecentSample();
    }

    public long getCacheHitMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitMostRecentSample();
    }

    public long getCacheOnDiskHitRate() {
        return this.getCacheHitOnDiskMostRecentSample();
    }

    public long getCacheHitOnDiskMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitOnDiskMostRecentSample();
    }

    public long getCacheMissExpiredMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissExpiredMostRecentSample();
    }

    public long getCacheMissRate() {
        return this.getCacheMissMostRecentSample();
    }

    public long getCacheMissMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissMostRecentSample();
    }

    public long getCacheInMemoryMissRate() {
        return this.getCacheMissInMemoryMostRecentSample();
    }

    public long getCacheMissInMemoryMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissInMemoryMostRecentSample();
    }

    public long getCacheOffHeapMissRate() {
        return this.getCacheMissOffHeapMostRecentSample();
    }

    public long getCacheMissOffHeapMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissOffHeapMostRecentSample();
    }

    public long getCacheOnDiskMissRate() {
        return this.getCacheMissOnDiskMostRecentSample();
    }

    public long getCacheMissOnDiskMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissOnDiskMostRecentSample();
    }

    public long getCacheMissNotFoundMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissNotFoundMostRecentSample();
    }

    public int getStatisticsAccuracy() {
        return this.cache.getSampledCacheStatistics().getStatisticsAccuracy();
    }

    public String getStatisticsAccuracyDescription() {
        return this.cache.getSampledCacheStatistics().getStatisticsAccuracyDescription();
    }

    public void clearStatistics() {
        try {
            this.cache.clearStatistics();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public boolean isStatisticsEnabled() {
        return this.cache.isStatisticsEnabled();
    }

    public boolean isSampledStatisticsEnabled() {
        return this.cache.getSampledCacheStatistics().isSampledStatisticsEnabled();
    }

    public void dispose() {
        this.cache.getCacheConfiguration().removeConfigurationListener(this);
    }

    public boolean isTerracottaClustered() {
        return this.cache.getCacheConfiguration().isTerracottaClustered();
    }

    public String getTerracottaConsistency() {
        TerracottaConfiguration.Consistency consistency = this.cache.getCacheConfiguration().getTerracottaConsistency();
        return consistency != null ? consistency.name() : "na";
    }

    public void enableStatistics() {
        if (!this.cache.isStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(true);
                this.cache.setStatisticsEnabled(true);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public void disableStatistics() {
        if (this.cache.isStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(false);
                this.cache.setStatisticsEnabled(false);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public void setStatisticsEnabled(boolean statsEnabled) {
        boolean oldValue = this.isStatisticsEnabled();
        if (oldValue != statsEnabled) {
            if (statsEnabled) {
                this.enableStatistics();
            } else {
                this.disableStatistics();
            }
        }
    }

    public void enableSampledStatistics() {
        if (!this.cache.isSampledStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(true);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public void disableSampledStatistics() {
        if (this.cache.isSampledStatisticsEnabled()) {
            try {
                this.cache.setSampledStatisticsEnabled(false);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public long getCacheAverageGetTime() {
        return this.getAverageGetTimeNanos();
    }

    public float getAverageGetTimeMillis() {
        try {
            return (float)this.getAverageGetTimeNanos() / 1000000.0f;
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getAverageGetTimeNanos() {
        try {
            return this.getAverageGetTimeNanosMostRecentSample();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getMaxGetTimeMillis() {
        try {
            return this.cache.getLiveCacheStatistics().getMaxGetTimeMillis();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getMinGetTimeMillis() {
        try {
            return this.cache.getLiveCacheStatistics().getMinGetTimeMillis();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getMaxGetTimeNanos() {
        try {
            return this.cache.getLiveCacheStatistics().getMaxGetTimeNanos();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getMinGetTimeNanos() {
        try {
            return this.cache.getLiveCacheStatistics().getMinGetTimeNanos();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getXaCommitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getXaCommitCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getXaRollbackCount() {
        try {
            return this.cache.getLiveCacheStatistics().getXaRollbackCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getXaRecoveredCount() {
        try {
            return this.cache.getLiveCacheStatistics().getXaRecoveredCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public boolean getHasWriteBehindWriter() {
        return this.cache.getWriterManager() instanceof WriteBehindManager && this.cache.getRegisteredCacheWriter() != null;
    }

    public long getWriterQueueLength() {
        try {
            return this.cache.getLiveCacheStatistics().getWriterQueueLength();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public int getWriterMaxQueueSize() {
        return this.cache.getCacheConfiguration().getCacheWriterConfiguration().getWriteBehindMaxQueueSize();
    }

    public int getWriterConcurrency() {
        return this.cache.getCacheConfiguration().getCacheWriterConfiguration().getWriteBehindConcurrency();
    }

    public long getCacheHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getCacheHitCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getCacheMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getCacheMissCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getInMemoryMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getInMemoryMissCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getOffHeapMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOffHeapMissCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getOnDiskMissCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOnDiskMissCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getCacheMissCountExpired() {
        try {
            return this.cache.getLiveCacheStatistics().getCacheMissCountExpired();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.cache.getCacheConfiguration().getDiskExpiryThreadIntervalSeconds();
    }

    public void setDiskExpiryThreadIntervalSeconds(long seconds) {
        if (this.getDiskExpiryThreadIntervalSeconds() != seconds) {
            try {
                this.cache.getCacheConfiguration().setDiskExpiryThreadIntervalSeconds(seconds);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public long getMaxEntriesLocalHeap() {
        return this.cache.getCacheConfiguration().getMaxEntriesLocalHeap();
    }

    public void setMaxEntriesLocalHeap(long maxEntries) {
        if (this.getMaxEntriesLocalHeap() != maxEntries) {
            try {
                this.cache.getCacheConfiguration().setMaxEntriesLocalHeap(maxEntries);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public long getMaxBytesLocalHeap() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalHeap();
    }

    public void setMaxBytesLocalHeap(long maxBytes) {
        try {
            long heapPoolSize;
            if (this.cache.getCacheManager().getConfiguration().isMaxBytesLocalHeapSet() && maxBytes > (heapPoolSize = this.cache.getCacheManager().getConfiguration().getMaxBytesLocalHeap())) {
                throw new IllegalArgumentException("Requested maxBytesLocalHeap (" + maxBytes + ") greater than available CacheManager heap pool size (" + heapPoolSize + ")");
            }
            this.cache.getCacheConfiguration().setMaxBytesLocalHeap(maxBytes);
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public void setMaxBytesLocalHeapAsString(String maxBytes) {
        try {
            this.cache.getCacheConfiguration().setMaxBytesLocalHeap(maxBytes);
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
        if (this.cache.getCacheConfiguration().isMaxBytesLocalHeapPercentageSet()) {
            long cacheAssignedMem = this.cache.getCacheManager().getConfiguration().getMaxBytesLocalHeap() * (long)this.cache.getCacheConfiguration().getMaxBytesLocalHeapPercentage().intValue() / 100L;
            this.setMaxBytesLocalHeap(cacheAssignedMem);
        }
    }

    public String getMaxBytesLocalHeapAsString() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalHeapAsString();
    }

    public long getMaxEntriesLocalDisk() {
        return this.cache.getCacheConfiguration().getMaxEntriesLocalDisk();
    }

    public void setMaxEntriesLocalDisk(long maxEntries) {
        if (this.getMaxEntriesLocalDisk() != maxEntries) {
            try {
                this.cache.getCacheConfiguration().setMaxEntriesLocalDisk(maxEntries);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public void setMaxBytesLocalDisk(long maxBytes) {
        try {
            long diskPoolSize;
            if (this.cache.getCacheManager().getConfiguration().isMaxBytesLocalDiskSet() && maxBytes > (diskPoolSize = this.cache.getCacheManager().getConfiguration().getMaxBytesLocalDisk())) {
                throw new IllegalArgumentException("Requested maxBytesLocalDisk (" + maxBytes + ") greater than available CacheManager disk pool size (" + diskPoolSize + ")");
            }
            this.cache.getCacheConfiguration().setMaxBytesLocalDisk(maxBytes);
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public void setMaxBytesLocalDiskAsString(String maxBytes) {
        try {
            this.cache.getCacheConfiguration().setMaxBytesLocalDisk(maxBytes);
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
        if (this.cache.getCacheConfiguration().isMaxBytesLocalDiskPercentageSet()) {
            long cacheAssignedMem = this.cache.getCacheManager().getConfiguration().getMaxBytesLocalDisk() * (long)this.cache.getCacheConfiguration().getMaxBytesLocalDiskPercentage().intValue() / 100L;
            this.setMaxBytesLocalDisk(cacheAssignedMem);
        }
    }

    public String getMaxBytesLocalDiskAsString() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalDiskAsString();
    }

    public int getMaxElementsOnDisk() {
        return this.cache.getCacheConfiguration().getMaxElementsOnDisk();
    }

    public void setMaxElementsOnDisk(int maxElements) {
        if (this.getMaxElementsOnDisk() != maxElements) {
            try {
                this.cache.getCacheConfiguration().setMaxElementsOnDisk(maxElements);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public long getMaxBytesLocalDisk() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalDisk();
    }

    public long getMaxBytesLocalOffHeap() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalOffHeap();
    }

    public String getMaxBytesLocalOffHeapAsString() {
        return this.cache.getCacheConfiguration().getMaxBytesLocalOffHeapAsString();
    }

    public String getMemoryStoreEvictionPolicy() {
        return this.cache.getCacheConfiguration().getMemoryStoreEvictionPolicy().toString();
    }

    public void setMemoryStoreEvictionPolicy(String evictionPolicy) {
        if (!this.getMemoryStoreEvictionPolicy().equals(evictionPolicy)) {
            try {
                this.cache.getCacheConfiguration().setMemoryStoreEvictionPolicy(evictionPolicy);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public long getTimeToIdleSeconds() {
        return this.cache.getCacheConfiguration().getTimeToIdleSeconds();
    }

    public void setTimeToIdleSeconds(long tti) {
        if (this.getTimeToIdleSeconds() != tti) {
            try {
                this.cache.getCacheConfiguration().setTimeToIdleSeconds(tti);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public long getTimeToLiveSeconds() {
        return this.cache.getCacheConfiguration().getTimeToLiveSeconds();
    }

    public void setTimeToLiveSeconds(long ttl) {
        if (this.getTimeToLiveSeconds() != ttl) {
            try {
                this.cache.getCacheConfiguration().setTimeToLiveSeconds(ttl);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public boolean isDiskPersistent() {
        return this.cache.getCacheConfiguration().isDiskPersistent();
    }

    public void setDiskPersistent(boolean diskPersistent) {
        if (this.isDiskPersistent() != diskPersistent) {
            try {
                this.cache.getCacheConfiguration().setDiskPersistent(diskPersistent);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public boolean isEternal() {
        return this.cache.getCacheConfiguration().isEternal();
    }

    public void setEternal(boolean eternal) {
        if (this.isEternal() != eternal) {
            try {
                this.cache.getCacheConfiguration().setEternal(eternal);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public boolean isOverflowToDisk() {
        return this.cache.getCacheConfiguration().isOverflowToDisk();
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        if (this.isOverflowToDisk() != overflowToDisk) {
            try {
                this.cache.getCacheConfiguration().setOverflowToDisk(overflowToDisk);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public boolean isLoggingEnabled() {
        return this.cache.getCacheConfiguration().getLogging();
    }

    public void setLoggingEnabled(boolean enabled) {
        if (this.isLoggingEnabled() != enabled) {
            try {
                this.cache.getCacheConfiguration().setLogging(enabled);
            }
            catch (RuntimeException e) {
                throw Utils.newPlainException(e);
            }
        }
    }

    public boolean isPinned() {
        return this.cache.getCacheConfiguration().getPinningConfiguration() != null;
    }

    public String getPinnedToStore() {
        PinningConfiguration pinningConfig = this.cache.getCacheConfiguration().getPinningConfiguration();
        return pinningConfig != null ? pinningConfig.getStore().name() : "na";
    }

    public long getEvictedCount() {
        try {
            return this.cache.getLiveCacheStatistics().getEvictedCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getExpiredCount() {
        try {
            return this.cache.getLiveCacheStatistics().getExpiredCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getInMemoryHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getInMemoryHitCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getOffHeapHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOffHeapHitCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    @Deprecated
    public long getOffHeapSize() {
        return this.getLocalOffHeapSize();
    }

    public long getOnDiskHitCount() {
        try {
            return this.cache.getLiveCacheStatistics().getOnDiskHitCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    @Deprecated
    public long getOnDiskSize() {
        return this.getLocalDiskSize();
    }

    public long getLocalDiskSize() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalDiskSize();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getLocalHeapSize() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalHeapSize();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getLocalOffHeapSize() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalOffHeapSize();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getLocalDiskSizeInBytes() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalDiskSizeInBytes();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getLocalHeapSizeInBytes() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalHeapSizeInBytes();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getLocalOffHeapSizeInBytes() {
        try {
            return this.cache.getLiveCacheStatistics().getLocalOffHeapSizeInBytes();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getPutCount() {
        try {
            return this.cache.getLiveCacheStatistics().getPutCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getRemovedCount() {
        try {
            return this.cache.getLiveCacheStatistics().getRemovedCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getSize() {
        try {
            return this.cache.getLiveCacheStatistics().getSize();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public long getInMemorySize() {
        return this.getLocalHeapSize();
    }

    public long getUpdateCount() {
        try {
            return this.cache.getLiveCacheStatistics().getUpdateCount();
        }
        catch (RuntimeException e) {
            throw Utils.newPlainException(e);
        }
    }

    public void deregistered(CacheConfiguration config) {
    }

    public void maxBytesLocalHeapChanged(long oldValue, long newValue) {
        if (oldValue != newValue) {
            this.setMaxBytesLocalHeap(newValue);
        }
    }

    public void maxBytesLocalDiskChanged(long oldValue, long newValue) {
        if (oldValue != newValue) {
            this.setMaxBytesLocalDisk(newValue);
        }
    }

    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
        if (oldCapacity != newCapacity) {
            this.setMaxElementsOnDisk(newCapacity);
        }
    }

    public void loggingChanged(boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.setLoggingEnabled(newValue);
        }
    }

    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        if (oldCapacity != newCapacity) {
            this.setMaxEntriesLocalHeap(newCapacity);
        }
    }

    public void registered(CacheConfiguration config) {
    }

    public void timeToIdleChanged(long oldTimeToIdle, long newTimeToIdle) {
        if (oldTimeToIdle != newTimeToIdle) {
            this.setTimeToIdleSeconds(newTimeToIdle);
        }
    }

    public void timeToLiveChanged(long oldTimeToLive, long newTimeToLive) {
        if (oldTimeToLive != newTimeToLive) {
            this.setTimeToLiveSeconds(newTimeToLive);
        }
    }

    public long getAverageSearchTime() {
        return this.cache.getAverageSearchTime();
    }

    public long getSearchesPerSecond() {
        return this.cache.getSearchesPerSecond();
    }

    public boolean getTransactional() {
        return this.cache.getCacheConfiguration().getTransactionalMode().isTransactional();
    }

    public boolean getSearchable() {
        return this.cache.getCacheConfiguration().getSearchable() != null;
    }

    public long getCacheSearchRate() {
        return this.cache.getSampledCacheStatistics().getSearchesPerSecond();
    }

    public long getCacheAverageSearchTime() {
        return this.cache.getSampledCacheStatistics().getAverageSearchTime();
    }

    public long getTransactionCommitRate() {
        return this.getCacheXaCommitsMostRecentSample();
    }

    public long getCacheXaCommitsMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheXaCommitsMostRecentSample();
    }

    public long getTransactionRollbackRate() {
        return this.getCacheXaRollbacksMostRecentSample();
    }

    public long getCacheXaRollbacksMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheXaRollbacksMostRecentSample();
    }

    Ehcache getCache() {
        return this.cache;
    }

    public int getCacheHitRatio() {
        return this.getCacheHitRatioMostRecentSample();
    }

    public int getCacheHitRatioMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitRatioMostRecentSample();
    }
}

