/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound.factories;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.compound.CompoundStore;
import net.sf.ehcache.store.compound.ElementSubstitute;
import net.sf.ehcache.store.compound.ElementSubstituteFilter;
import net.sf.ehcache.store.compound.factories.CapacityLimitedInMemoryFactory;
import net.sf.ehcache.store.compound.factories.DiskStorageFactory;
import net.sf.ehcache.transaction.SoftLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskOverflowStorageFactory
extends DiskStorageFactory<ElementSubstitute> {
    private static final int MAX_EVICT = 5;
    private static final int SAMPLE_SIZE = 30;
    private static final Logger LOG = LoggerFactory.getLogger(DiskOverflowStorageFactory.class);
    private final ElementSubstituteFilter<DiskStorageFactory.DiskSubstitute> filter = new ElementSubstituteFilter<DiskStorageFactory.DiskSubstitute>(){

        @Override
        public boolean allows(Object object) {
            return DiskOverflowStorageFactory.this.created(object);
        }
    };
    private final AtomicInteger count = new AtomicInteger();
    private volatile CapacityLimitedInMemoryFactory memory;
    private volatile int capacity;

    public DiskOverflowStorageFactory(Ehcache cache, String diskPath) {
        super(DiskOverflowStorageFactory.getDataFile(diskPath, cache), cache.getCacheConfiguration().getDiskExpiryThreadIntervalSeconds(), cache.getCacheConfiguration().getDiskSpoolBufferSizeMB(), cache.getCacheEventNotificationService(), true, cache.getCacheConfiguration().getDiskAccessStripes());
        this.capacity = cache.getCacheConfiguration().getMaxElementsOnDisk();
    }

    private static File getDataFile(String diskPath, Ehcache cache) {
        if (diskPath == null) {
            throw new CacheException(cache.getName() + " Cache: Could not create disk store. " + "This CacheManager configuration does not allow creation of DiskStores. " + "If you wish to create DiskStores, please configure a diskStore path.");
        }
        File diskDir = new File(diskPath);
        if (!diskDir.mkdirs() && !diskDir.isDirectory()) {
            if (diskDir.exists()) {
                throw new CacheException("Store directory \"" + diskDir.getAbsolutePath() + "\" exists and is not a directory.");
            }
            throw new CacheException("Could not create cache directory \"" + diskDir.getAbsolutePath() + "\".");
        }
        File data = new File(diskDir, DiskOverflowStorageFactory.getDataFileName(cache));
        LOG.debug("Deleting data file " + data.getName());
        data.delete();
        return data;
    }

    private static final String getDataFileName(Ehcache cache) {
        String safeName = cache.getName().replace('/', '_');
        return safeName + ".data";
    }

    public void primary(CapacityLimitedInMemoryFactory memory) {
        this.memory = memory;
    }

    @Override
    public ElementSubstitute create(Object key, Element element) throws IllegalArgumentException {
        if (element.isSerializable() || element.getObjectValue() instanceof SoftLock) {
            int overflow;
            int size = this.count.incrementAndGet();
            if (this.capacity > 0 && (overflow = size - this.capacity) > 0) {
                this.evict(Math.min(5, overflow), key, size);
            }
            return new OverflowPlaceholder(element);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Element retrieve(Object key, ElementSubstitute proxy) {
        if (proxy instanceof DiskStorageFactory.DiskMarker) {
            try {
                OverflowDiskMarker marker = (OverflowDiskMarker)proxy;
                Element e = marker.getSoftLockedElement();
                if (e == null) {
                    e = this.read(marker);
                }
                if (key != null) {
                    this.store.tryFault(key, marker, this.memory.create(key, e));
                }
                return e;
            }
            catch (IOException e) {
                throw new CacheException(e);
            }
            catch (ClassNotFoundException e) {
                throw new CacheException(e);
            }
        }
        Element e = ((DiskStorageFactory.Placeholder)proxy).getElement();
        if (key != null) {
            this.store.fault(key, proxy, this.memory.create(key, e));
        }
        return e;
    }

    @Override
    public void free(Lock lock, ElementSubstitute substitute) {
        this.count.decrementAndGet();
        super.free(lock, substitute);
    }

    @Override
    public void unbind(CompoundStore localStore) {
        try {
            this.shutdown();
            this.delete();
        }
        catch (IOException e) {
            LOG.error("Could not shut down disk cache. Initial cause was " + e.getMessage(), (Throwable)e);
        }
    }

    private void evict(int n, Object keyHint, int size) {
        for (int i = 0; i < n; ++i) {
            DiskStorageFactory.DiskSubstitute target = this.getEvictionTarget(keyHint, size);
            if (target == null) continue;
            this.store.evict(target.getKey(), target);
        }
    }

    private DiskStorageFactory.DiskSubstitute getEvictionTarget(Object keyHint, int size) {
        List<DiskStorageFactory.DiskSubstitute> sample = this.store.getRandomSample(this.filter, Math.min(30, size), keyHint);
        DiskStorageFactory.DiskSubstitute target = null;
        for (DiskStorageFactory.DiskSubstitute substitute : sample) {
            if (target != null && substitute.getHitCount() >= target.getHitCount()) continue;
            target = substitute;
        }
        return target;
    }

    @Override
    protected DiskStorageFactory.DiskMarker createMarker(long position, int size, Element element) {
        return new OverflowDiskMarker(this, position, size, element);
    }

    public int getSize() {
        return this.count.get();
    }

    public void setCapacity(int newCapacity) {
        this.capacity = newCapacity;
    }

    @Override
    public boolean created(Object object) {
        return object instanceof ElementSubstitute && ((ElementSubstitute)object).getFactory() == this;
    }

    private final class OverflowDiskWriteTask
    extends DiskStorageFactory.DiskWriteTask {
        private OverflowDiskWriteTask(DiskStorageFactory.Placeholder p) {
            super(p);
        }

        public DiskStorageFactory.DiskMarker call() {
            int overflow;
            DiskStorageFactory.DiskMarker result = super.call();
            int size = DiskOverflowStorageFactory.this.count.incrementAndGet();
            if (DiskOverflowStorageFactory.this.capacity > 0 && (overflow = size - DiskOverflowStorageFactory.this.capacity) > 0) {
                DiskOverflowStorageFactory.this.evict(Math.min(5, overflow), result.getKey(), size);
            }
            return result;
        }
    }

    class OverflowPlaceholder
    extends DiskStorageFactory.Placeholder {
        OverflowPlaceholder(Element element) {
            super(DiskOverflowStorageFactory.this, element);
        }

        public void installed() {
            DiskOverflowStorageFactory.this.schedule(new OverflowDiskWriteTask(this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OverflowDiskMarker
    extends DiskStorageFactory.DiskMarker {
        private static final AtomicReferenceFieldUpdater<OverflowDiskMarker, Element> SOFTLOCKED_ELEMENT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OverflowDiskMarker.class, Element.class, "softLockedElement");
        private final long expiry;
        private volatile transient Element softLockedElement;

        OverflowDiskMarker(DiskStorageFactory<? extends ElementSubstitute> factory, long position, int size, Element element) {
            super(factory, position, size, element);
            if (element.getObjectValue() instanceof SoftLock) {
                SOFTLOCKED_ELEMENT_UPDATER.compareAndSet(this, null, element);
            }
            this.expiry = element.getExpirationTime();
        }

        OverflowDiskMarker(DiskStorageFactory<? extends ElementSubstitute> factory, long position, int size, Object key, long hits, long expiry) {
            super(factory, position, size, key, hits);
            this.expiry = expiry;
        }

        Element getSoftLockedElement() {
            return SOFTLOCKED_ELEMENT_UPDATER.get(this);
        }

        @Override
        long getExpirationTime() {
            return this.expiry;
        }
    }
}

