/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate.regions;

import java.util.Properties;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.hibernate.regions.EhcacheTransactionalDataRegion;
import net.sf.ehcache.hibernate.strategy.NonStrictReadWriteEhcacheEntityRegionAccessStrategy;
import net.sf.ehcache.hibernate.strategy.ReadOnlyEhcacheEntityRegionAccessStrategy;
import net.sf.ehcache.hibernate.strategy.ReadWriteEhcacheEntityRegionAccessStrategy;
import net.sf.ehcache.hibernate.strategy.TransactionalEhcacheEntityRegionAccessStrategy;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheEntityRegion
extends EhcacheTransactionalDataRegion
implements EntityRegion {
    private static final Logger LOG = LoggerFactory.getLogger(EhcacheEntityRegion.class);

    public EhcacheEntityRegion(Ehcache underlyingCache, Settings settings, CacheDataDescription metadata, Properties properties) {
        super(underlyingCache, settings, metadata, properties);
    }

    public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (AccessType.READ_ONLY.equals(accessType)) {
            if (this.metadata.isMutable()) {
                LOG.warn("read-only cache configured for mutable entity [" + this.getName() + "]");
            }
            return new ReadOnlyEhcacheEntityRegionAccessStrategy(this, this.settings);
        }
        if (AccessType.READ_WRITE.equals(accessType)) {
            return new ReadWriteEhcacheEntityRegionAccessStrategy(this, this.settings);
        }
        if (AccessType.NONSTRICT_READ_WRITE.equals(accessType)) {
            return new NonStrictReadWriteEhcacheEntityRegionAccessStrategy(this, this.settings);
        }
        if (AccessType.TRANSACTIONAL.equals(accessType)) {
            return new TransactionalEhcacheEntityRegionAccessStrategy(this, this.getEhcache(), this.settings);
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }
}

