/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config.generator.model.elements;

import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.config.CopyStrategyConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.config.generator.model.NodeElement;
import net.sf.ehcache.config.generator.model.SimpleNodeAttribute;
import net.sf.ehcache.config.generator.model.SimpleNodeElement;
import net.sf.ehcache.config.generator.model.elements.CacheWriterConfigurationElement;
import net.sf.ehcache.config.generator.model.elements.CopyStrategyConfigurationElement;
import net.sf.ehcache.config.generator.model.elements.FactoryConfigurationElement;
import net.sf.ehcache.config.generator.model.elements.TerracottaConfigurationElement;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

public class CacheConfigurationElement
extends SimpleNodeElement {
    private final CacheConfiguration cacheConfiguration;

    public CacheConfigurationElement(NodeElement parent, CacheConfiguration cacheConfiguration) {
        super(parent, "cache");
        this.cacheConfiguration = cacheConfiguration;
        this.init();
    }

    private void init() {
        if (this.cacheConfiguration == null) {
            return;
        }
        this.addAttribute(new SimpleNodeAttribute("name", this.cacheConfiguration.getName()).optional(false));
        CacheConfigurationElement.addCommonAttributesWithDefaultCache(this, this.cacheConfiguration);
        this.addAttribute(new SimpleNodeAttribute("logging", this.cacheConfiguration.getLogging()).optional(true).defaultValue(false));
        CacheConfigurationElement.addCommonChildElementsWithDefaultCache(this, this.cacheConfiguration);
    }

    public static void addCommonAttributesWithDefaultCache(NodeElement element, CacheConfiguration cacheConfiguration) {
        element.addAttribute(new SimpleNodeAttribute("eternal", cacheConfiguration.isEternal()).optional(false));
        element.addAttribute(new SimpleNodeAttribute("maxElementsInMemory", cacheConfiguration.getMaxElementsInMemory()).optional(false));
        element.addAttribute(new SimpleNodeAttribute("overflowToDisk", cacheConfiguration.isOverflowToDisk()).optional(false));
        element.addAttribute(new SimpleNodeAttribute("clearOnFlush", cacheConfiguration.isClearOnFlush()).optional(true).defaultValue(String.valueOf(true)));
        element.addAttribute(new SimpleNodeAttribute("diskAccessStripes", cacheConfiguration.getDiskAccessStripes()).optional(true).defaultValue(1));
        element.addAttribute(new SimpleNodeAttribute("diskPersistent", cacheConfiguration.isDiskPersistent()).optional(true).defaultValue(false));
        element.addAttribute(new SimpleNodeAttribute("diskSpoolBufferSizeMB", cacheConfiguration.getDiskSpoolBufferSizeMB()).optional(true).defaultValue(30));
        element.addAttribute(new SimpleNodeAttribute("diskExpiryThreadIntervalSeconds", cacheConfiguration.getDiskExpiryThreadIntervalSeconds()).optional(true).defaultValue(120L));
        element.addAttribute(new SimpleNodeAttribute("copyOnWrite", cacheConfiguration.isCopyOnWrite()).optional(true).defaultValue(false));
        element.addAttribute(new SimpleNodeAttribute("copyOnRead", cacheConfiguration.isCopyOnRead()).optional(true).defaultValue(false));
        element.addAttribute(new SimpleNodeAttribute("timeToIdleSeconds", cacheConfiguration.getTimeToIdleSeconds()).optional(true).defaultValue(0L));
        element.addAttribute(new SimpleNodeAttribute("timeToLiveSeconds", cacheConfiguration.getTimeToLiveSeconds()).optional(true).defaultValue(0L));
        element.addAttribute(new SimpleNodeAttribute("maxElementsOnDisk", cacheConfiguration.getMaxElementsOnDisk()).optional(true).defaultValue(0));
        element.addAttribute(new SimpleNodeAttribute("maxMemoryOffHeap", cacheConfiguration.getMaxMemoryOffHeap()).optional(true).defaultValue((String)null));
        element.addAttribute(new SimpleNodeAttribute("overflowToOffHeap", cacheConfiguration.isOverflowToOffHeap()).optional(true).defaultValue(false));
        element.addAttribute(new SimpleNodeAttribute("cacheLoaderTimeoutMillis", cacheConfiguration.getCacheLoaderTimeoutMillis()).optional(true).defaultValue(0L));
        element.addAttribute(new SimpleNodeAttribute("transactionalMode", cacheConfiguration.getTransactionalMode()).optional(true).defaultValue(CacheConfiguration.DEFAULT_TRANSACTIONAL_MODE));
        element.addAttribute(new SimpleNodeAttribute("statistics", cacheConfiguration.getStatistics()).optional(true).defaultValue(false));
        element.addAttribute(new SimpleNodeAttribute("memoryStoreEvictionPolicy", MemoryStoreEvictionPolicy.MemoryStoreEvictionPolicyEnum.valueOf(cacheConfiguration.getMemoryStoreEvictionPolicy().toString())).optional(true).defaultValue(CacheConfiguration.DEFAULT_MEMORY_STORE_EVICTION_POLICY.toString().toLowerCase()));
    }

    public static void addCommonChildElementsWithDefaultCache(NodeElement element, CacheConfiguration cacheConfiguration) {
        CacheWriterConfiguration cacheWriterConfiguration;
        CopyStrategyConfiguration copyStrategyConfiguration;
        CacheConfiguration.CacheExceptionHandlerFactoryConfiguration cacheExceptionHandlerFactoryConfiguration;
        for (FactoryConfigurationElement child : CacheConfigurationElement.getAllFactoryElements(element, "cacheEventListenerFactory", cacheConfiguration.getCacheEventListenerConfigurations())) {
            CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheEventListenerFactoryConfiguration)child.getFactoryConfiguration();
            child.addAttribute(new SimpleNodeAttribute("listenFor", factoryConfiguration.getListenFor()));
            element.addChildElement(child);
        }
        CacheConfigurationElement.addAllFactoryConfigsAsChildElements(element, "cacheExtensionFactory", cacheConfiguration.getCacheExtensionConfigurations());
        CacheConfigurationElement.addAllFactoryConfigsAsChildElements(element, "cacheLoaderFactory", cacheConfiguration.getCacheLoaderConfigurations());
        CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration = cacheConfiguration.getBootstrapCacheLoaderFactoryConfiguration();
        if (bootstrapCacheLoaderFactoryConfiguration != null) {
            element.addChildElement(new FactoryConfigurationElement(element, "bootstrapCacheLoaderFactory", bootstrapCacheLoaderFactoryConfiguration));
        }
        if ((cacheExceptionHandlerFactoryConfiguration = cacheConfiguration.getCacheExceptionHandlerFactoryConfiguration()) != null) {
            element.addChildElement(new FactoryConfigurationElement(element, "cacheExceptionHandlerFactory", cacheExceptionHandlerFactoryConfiguration));
        }
        if ((copyStrategyConfiguration = cacheConfiguration.getCopyStrategyConfiguration()) != null && !copyStrategyConfiguration.equals(CacheConfiguration.DEFAULT_COPY_STRATEGY_CONFIGURATION)) {
            element.addChildElement(new CopyStrategyConfigurationElement(element, copyStrategyConfiguration));
        }
        if ((cacheWriterConfiguration = cacheConfiguration.getCacheWriterConfiguration()) != null && !CacheConfiguration.DEFAULT_CACHE_WRITER_CONFIGURATION.equals(cacheWriterConfiguration)) {
            element.addChildElement(new CacheWriterConfigurationElement(element, cacheWriterConfiguration));
        }
        CacheConfigurationElement.addAllFactoryConfigsAsChildElements(element, "cacheDecoratorFactory", cacheConfiguration.getCacheDecoratorConfigurations());
        TerracottaConfiguration terracottaConfiguration = cacheConfiguration.getTerracottaConfiguration();
        if (terracottaConfiguration != null) {
            element.addChildElement(new TerracottaConfigurationElement(element, terracottaConfiguration));
        }
    }
}

