/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import net.sf.ehcache.Element;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.StoreWriteCommand;
import net.sf.ehcache.writer.CacheWriterManager;

public class StoreReplaceElementCommand
implements StoreWriteCommand {
    private final Element oldElement;
    private final Element newElement;

    public StoreReplaceElementCommand(Element oldElement, Element newElement) {
        this.oldElement = oldElement;
        this.newElement = newElement;
    }

    public String getCommandName() {
        return "REPLACE_ELEMENT";
    }

    public boolean execute(Store store) {
        return store.replace(this.oldElement, this.newElement);
    }

    public boolean execute(CacheWriterManager cacheWriterManager) {
        return false;
    }

    public boolean isPut(Object key) {
        return this.newElement.getKey().equals(key);
    }

    public boolean isRemove(Object key) {
        return false;
    }
}

