/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import net.sf.ehcache.Element;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.StoreWriteCommand;
import net.sf.ehcache.writer.CacheWriterManager;

public class StorePutIfAbsentCommand
implements StoreWriteCommand {
    private final Element element;

    public StorePutIfAbsentCommand(Element element) {
        this.element = element;
    }

    public String getCommandName() {
        return "PUT_IF_ABSENT";
    }

    public boolean execute(Store store) {
        return store.putIfAbsent(this.element) == null;
    }

    public boolean execute(CacheWriterManager cacheWriterManager) {
        return false;
    }

    public boolean isPut(Object key) {
        return this.element.getKey().equals(key);
    }

    public boolean isRemove(Object key) {
        return false;
    }
}

