/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound.impl;

import java.io.IOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.store.FifoPolicy;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.LruPolicy;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.compound.CompoundStore;
import net.sf.ehcache.store.compound.factories.CapacityLimitedInMemoryFactory;

public final class MemoryOnlyStore
extends CompoundStore
implements CacheConfigurationListener {
    private final CapacityLimitedInMemoryFactory memoryFactory;
    private final CacheConfiguration config;

    private MemoryOnlyStore(CapacityLimitedInMemoryFactory memory, CacheConfiguration config) {
        super(memory, memory, config.isCopyOnRead(), config.isCopyOnWrite(), config.getCopyStrategy());
        this.memoryFactory = memory;
        this.config = config;
    }

    public static MemoryOnlyStore create(Cache cache, String diskStorePath) {
        CacheConfiguration config = cache.getCacheConfiguration();
        CapacityLimitedInMemoryFactory memory = new CapacityLimitedInMemoryFactory(null, config.getMaxElementsInMemory(), MemoryOnlyStore.determineEvictionPolicy(config), cache.getCacheEventNotificationService());
        MemoryOnlyStore store = new MemoryOnlyStore(memory, config);
        cache.getCacheConfiguration().addConfigurationListener(store);
        return store;
    }

    private static final Policy determineEvictionPolicy(CacheConfiguration config) {
        MemoryStoreEvictionPolicy policySelection = config.getMemoryStoreEvictionPolicy();
        if (policySelection.equals(MemoryStoreEvictionPolicy.LRU)) {
            return new LruPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.FIFO)) {
            return new FifoPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.LFU)) {
            return new LfuPolicy();
        }
        throw new IllegalArgumentException(policySelection + " isn't a valid eviction policy");
    }

    public boolean bufferFull() {
        return false;
    }

    public boolean containsKeyInMemory(Object key) {
        return this.containsKey(key);
    }

    public boolean containsKeyOnDisk(Object key) {
        return false;
    }

    public void expireElements() {
        this.memoryFactory.expireElements();
    }

    public void flush() throws IOException {
        if (this.config.isClearOnFlush()) {
            this.removeAll();
        }
    }

    public Policy getInMemoryEvictionPolicy() {
        return this.memoryFactory.getEvictionPolicy();
    }

    public int getInMemorySize() {
        return this.getSize();
    }

    public long getInMemorySizeInBytes() {
        return this.memoryFactory.getSizeInBytes();
    }

    public int getOnDiskSize() {
        return 0;
    }

    public long getOnDiskSizeInBytes() {
        return 0L;
    }

    public int getTerracottaClusteredSize() {
        return 0;
    }

    public void setInMemoryEvictionPolicy(Policy policy) {
        this.memoryFactory.setEvictionPolicy(policy);
    }

    public void deregistered(CacheConfiguration config) {
    }

    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
    }

    public void loggingChanged(boolean oldValue, boolean newValue) {
    }

    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        this.memoryFactory.setCapacity(newCapacity);
    }

    public void registered(CacheConfiguration config) {
    }

    public void timeToIdleChanged(long oldTimeToIdle, long newTimeToIdle) {
    }

    public void timeToLiveChanged(long oldTimeToLive, long newTimeToLive) {
    }
}

