/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.StoreExpireAllElementsCommand;
import net.sf.ehcache.transaction.StorePutCommand;
import net.sf.ehcache.transaction.StorePutWithWriterCommandImpl;
import net.sf.ehcache.transaction.StoreRemoveAllCommand;
import net.sf.ehcache.transaction.StoreRemoveCommand;
import net.sf.ehcache.transaction.StoreRemoveWithWriterCommand;
import net.sf.ehcache.transaction.TransactionContext;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import net.sf.ehcache.transaction.xa.EhcacheXAResourceImpl;
import net.sf.ehcache.transaction.xa.EhcacheXAStore;
import net.sf.ehcache.transaction.xa.TwoPcExecutionListener;
import net.sf.ehcache.writer.CacheWriterManager;

public class XATransactionalStore
implements Store {
    private final Store underlyingStore;
    private final Store oldVersionStore;
    private Ehcache cache;
    private EhcacheXAStore ehcacheXAStore;
    private TransactionManagerLookup transactionManagerLookup;
    private TransactionManager txnManager;
    private final ConcurrentHashMap<Transaction, TransactionContext> transactionToContextMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Transaction, EhcacheXAResource> transactionToXAResourceMap = new ConcurrentHashMap();

    public XATransactionalStore(Ehcache cache, EhcacheXAStore ehcacheXAStore, TransactionManagerLookup transactionManagerLookup) {
        this.cache = cache;
        this.ehcacheXAStore = ehcacheXAStore;
        this.transactionManagerLookup = transactionManagerLookup;
        this.txnManager = transactionManagerLookup.getTransactionManager();
        this.underlyingStore = ehcacheXAStore.getUnderlyingStore();
        this.oldVersionStore = ehcacheXAStore.getOldVersionStore();
    }

    public boolean put(Element element) throws CacheException {
        return this.internalPut(new StorePutCommand(element));
    }

    private boolean internalPut(StorePutCommand putCommand) {
        boolean isNull;
        Element element = putCommand.getElement();
        if (element == null) {
            return true;
        }
        TransactionContext context = this.getOrCreateTransactionContext();
        boolean bl = isNull = this.underlyingStore.get(element.getKey()) == null;
        if (isNull) {
            isNull = context.get(element.getKey()) == null;
        }
        context.addCommand(putCommand, element);
        return isNull;
    }

    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        return this.internalPut(new StorePutWithWriterCommandImpl(element));
    }

    public Element get(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        Element element = context.get(key);
        if (element == null && !context.isRemoved(key)) {
            element = this.getFromUnderlyingStore(key);
        }
        return element;
    }

    public Element getQuiet(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        Element element = context.get(key);
        if (element == null && !context.isRemoved(key)) {
            element = this.getQuietFromUnderlyingStore(key);
        }
        return element;
    }

    public Object[] getKeyArray() {
        TransactionContext context = this.getOrCreateTransactionContext();
        HashSet<Object> keys = new HashSet<Object>(Arrays.asList(this.underlyingStore.getKeyArray()));
        keys.addAll(context.getAddedKeys());
        keys.removeAll(context.getRemovedKeys());
        return keys.toArray();
    }

    public Element remove(Object key) {
        return this.removeInternal(new StoreRemoveCommand(new CacheEntry(key, this.retrieveElement(key))));
    }

    private Element retrieveElement(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        Element element = context.get(key);
        if (element == null && !context.isRemoved(key)) {
            element = this.getQuietFromUnderlyingStore(key);
        }
        return element;
    }

    private Element removeInternal(StoreRemoveCommand command) {
        Element element = command.getEntry().getElement();
        this.getOrCreateTransactionContext().addCommand(command, element);
        return element;
    }

    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        return this.removeInternal(new StoreRemoveWithWriterCommand(new CacheEntry(key, this.retrieveElement(key))));
    }

    public void removeAll() throws CacheException {
        this.getOrCreateTransactionContext().addCommand(new StoreRemoveAllCommand(), null);
    }

    public void dispose() {
        this.underlyingStore.dispose();
    }

    public int getSize() {
        TransactionContext context = this.getOrCreateTransactionContext();
        int size = this.underlyingStore.getSize();
        return size + context.getSizeModifier();
    }

    public int getTerracottaClusteredSize() {
        TransactionContext context = this.getOrCreateTransactionContext();
        return this.underlyingStore.getTerracottaClusteredSize() + context.getSizeModifier();
    }

    public long getSizeInBytes() {
        this.getOrCreateTransactionContext();
        return this.underlyingStore.getSizeInBytes();
    }

    public Status getStatus() {
        return this.underlyingStore.getStatus();
    }

    public boolean containsKey(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        return !context.isRemoved(key) && (context.getAddedKeys().contains(key) || this.underlyingStore.containsKey(key));
    }

    public void expireElements() {
        this.getOrCreateTransactionContext().addCommand(new StoreExpireAllElementsCommand(), null);
    }

    public void flush() throws IOException {
        this.underlyingStore.flush();
    }

    public boolean bufferFull() {
        return this.underlyingStore.bufferFull();
    }

    public Policy getEvictionPolicy() {
        return this.underlyingStore.getEvictionPolicy();
    }

    public void setEvictionPolicy(Policy policy) {
        this.underlyingStore.setEvictionPolicy(policy);
    }

    public Object getInternalContext() {
        return this.underlyingStore.getInternalContext();
    }

    public boolean isCacheCoherent() {
        return this.underlyingStore.isCacheCoherent();
    }

    public boolean isClusterCoherent() {
        return this.underlyingStore.isClusterCoherent();
    }

    public boolean isNodeCoherent() {
        return this.underlyingStore.isNodeCoherent();
    }

    public void setNodeCoherent(boolean coherent) {
        this.underlyingStore.setNodeCoherent(coherent);
    }

    public void waitUntilClusterCoherent() {
        this.underlyingStore.waitUntilClusterCoherent();
    }

    private Element getFromUnderlyingStore(Object key) {
        Element element = this.oldVersionStore.get(key);
        if (element == null) {
            element = this.underlyingStore.get(key);
        }
        return element;
    }

    private Element getQuietFromUnderlyingStore(Object key) {
        Element element = this.oldVersionStore.getQuiet(key);
        if (element == null) {
            element = this.underlyingStore.getQuiet(key);
        }
        return element;
    }

    public EhcacheXAResource getOrCreateXAResource() {
        try {
            Transaction transaction = this.txnManager.getTransaction();
            if (transaction == null) {
                throw new CacheException("Cache " + this.cache.getName() + " can only be accessed within a JTA Transaction!");
            }
            EhcacheXAResource xaResource = this.transactionToXAResourceMap.get(transaction);
            if (xaResource == null) {
                xaResource = new EhcacheXAResourceImpl(this.cache, this.txnManager, this.ehcacheXAStore);
                this.transactionToXAResourceMap.put(transaction, xaResource);
            }
            return xaResource;
        }
        catch (SystemException e) {
            throw new CacheException(e);
        }
    }

    private TransactionContext getOrCreateTransactionContext() {
        try {
            Transaction transaction = this.txnManager.getTransaction();
            if (transaction == null) {
                throw new CacheException("Cache " + this.cache.getName() + " can only be accessed within a JTA Transaction!");
            }
            TransactionContext context = this.transactionToContextMap.get(transaction);
            if (context != null) {
                return context;
            }
            EhcacheXAResource xaResource = this.getOrCreateXAResource();
            this.transactionManagerLookup.register(xaResource);
            context = xaResource.createTransactionContext();
            xaResource.addTwoPcExecutionListener(new CleanupTransactionContext(transaction));
            this.transactionToContextMap.put(transaction, context);
            return context;
        }
        catch (SystemException e) {
            throw new CacheException(e);
        }
        catch (RollbackException e) {
            throw new CacheException(e);
        }
    }

    private final class CleanupTransactionContext
    implements TwoPcExecutionListener {
        private Transaction transaction;

        private CleanupTransactionContext(Transaction transaction) {
            this.transaction = transaction;
        }

        public void beforePrepare(EhcacheXAResource xaResource) {
        }

        public void afterCommitOrRollback(EhcacheXAResource xaResource) {
            XATransactionalStore.this.transactionToContextMap.remove(this.transaction);
            XATransactionalStore.this.transactionToXAResourceMap.remove(this.transaction);
            XATransactionalStore.this.transactionManagerLookup.unregister(xaResource);
        }
    }
}

