/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.writer.writethrough;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.CacheWriterManager;
import net.sf.ehcache.writer.CacheWriterManagerException;

public class WriteThroughManager
implements CacheWriterManager {
    private volatile Cache cache;

    public void init(Cache cache) throws CacheException {
        this.cache = cache;
    }

    public void put(Element element) throws CacheException {
        try {
            CacheWriter writer = this.cache.getRegisteredCacheWriter();
            if (writer != null) {
                writer.write(element);
            }
        }
        catch (RuntimeException e) {
            throw new CacheWriterManagerException(e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            CacheWriter writer = this.cache.getRegisteredCacheWriter();
            if (writer != null) {
                writer.delete(key);
            }
        }
        catch (RuntimeException e) {
            throw new CacheWriterManagerException(e);
        }
    }

    public void dispose() {
    }
}

