/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.writer.writebehind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.writebehind.CastingOperationConverter;
import net.sf.ehcache.writer.writebehind.OperationsFilter;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import net.sf.ehcache.writer.writebehind.operations.DeleteOperation;
import net.sf.ehcache.writer.writebehind.operations.SingleOperation;
import net.sf.ehcache.writer.writebehind.operations.WriteOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteBehindQueue
implements WriteBehind {
    private static final Logger LOGGER = Logger.getLogger(WriteBehindQueue.class.getName());
    private static final int MS_IN_SEC = 1000;
    private final String cacheName;
    private final long minWriteDelayMs;
    private final long maxWriteDelayMs;
    private final boolean writeBatching;
    private final int writeBatchSize;
    private final int retryAttempts;
    private final int retryAttemptDelaySeconds;
    private final Thread processingThread;
    private final ReentrantReadWriteLock queueLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock queueReadLock = this.queueLock.readLock();
    private final ReentrantReadWriteLock.WriteLock queueWriteLock = this.queueLock.writeLock();
    private final Condition queueIsEmpty = this.queueWriteLock.newCondition();
    private final AtomicLong lastProcessing = new AtomicLong(System.currentTimeMillis());
    private final AtomicLong lastWorkDone = new AtomicLong(System.currentTimeMillis());
    private final AtomicBoolean busyProcessing = new AtomicBoolean(false);
    private volatile OperationsFilter filter;
    private List<SingleOperation> waiting = new ArrayList<SingleOperation>();
    private CacheWriter cacheWriter;
    private boolean cancelled;

    public WriteBehindQueue(CacheConfiguration config) {
        this.cacheName = config.getName();
        CacheWriterConfiguration cacheConfig = config.getCacheWriterConfiguration();
        this.minWriteDelayMs = cacheConfig.getMinWriteDelay() * 1000;
        this.maxWriteDelayMs = cacheConfig.getMaxWriteDelay() * 1000;
        this.writeBatching = cacheConfig.getWriteBatching();
        this.writeBatchSize = cacheConfig.getWriteBatchSize();
        this.retryAttempts = cacheConfig.getRetryAttempts();
        this.retryAttemptDelaySeconds = cacheConfig.getRetryAttemptDelaySeconds();
        this.processingThread = new Thread((Runnable)new ProcessingThread(), this.cacheName + " write-behind");
        this.processingThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(CacheWriter writer) {
        this.queueWriteLock.lock();
        try {
            this.cacheWriter = writer;
            if (this.processingThread.isAlive()) {
                throw new CacheException("A thread with name " + this.processingThread.getName() + " already exists and is still running");
            }
            this.processingThread.start();
        }
        finally {
            this.queueWriteLock.unlock();
        }
    }

    @Override
    public void setOperationsFilter(OperationsFilter filter) {
        this.filter = filter;
    }

    private long getLastProcessing() {
        return this.lastProcessing.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processItems() throws CacheException {
        if (this.busyProcessing.get()) {
            throw new CacheException("The write behind queue for cache '" + this.cacheName + "' is already busy processing.");
        }
        this.busyProcessing.set(true);
        this.lastProcessing.set(System.currentTimeMillis());
        try {
            int workSize;
            List<SingleOperation> quarantined;
            this.queueWriteLock.lock();
            try {
                if (this.waiting.size() > 0) {
                    quarantined = this.waiting;
                    this.waiting = new ArrayList<SingleOperation>();
                } else {
                    quarantined = null;
                }
                workSize = quarantined != null ? quarantined.size() : 0;
            }
            finally {
                this.queueWriteLock.unlock();
            }
            if (0 == workSize) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(this.getThreadName() + " : processItems() : nothing to process");
                }
                return;
            }
            this.filterQuarantined(quarantined);
            if (this.writeBatching && this.writeBatchSize > 0 && workSize < this.writeBatchSize && this.maxWriteDelayMs > this.lastProcessing.get() - this.lastWorkDone.get()) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(this.getThreadName() + " : processItems() : only " + workSize + " work items available, waiting for " + this.writeBatchSize + " items to fill up a batch");
                }
                this.reassemble(quarantined);
                return;
            }
            try {
                this.lastWorkDone.set(System.currentTimeMillis());
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(this.getThreadName() + " : processItems() : processing started");
                }
                this.processQuarantinedItems(quarantined);
            }
            catch (RuntimeException e) {
                this.reassemble(quarantined);
                throw e;
            }
            catch (Error e) {
                this.reassemble(quarantined);
                throw e;
            }
        }
        finally {
            this.busyProcessing.set(false);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.getThreadName() + " : processItems() : processing finished");
            }
        }
    }

    private void filterQuarantined(List<SingleOperation> quarantined) {
        OperationsFilter operationsFilter = this.filter;
        if (operationsFilter != null) {
            operationsFilter.filter(quarantined, CastingOperationConverter.getInstance());
        }
    }

    private void processQuarantinedItems(List<SingleOperation> quarantined) {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(this.getThreadName() + " : processItems() : processing " + quarantined.size() + " quarantined items");
        }
        while (!quarantined.isEmpty()) {
            if (this.writeBatching && this.writeBatchSize > 0) {
                this.processBatchedOperations(quarantined);
                continue;
            }
            this.processSingleOperation(quarantined);
        }
    }

    private void processBatchedOperations(List<SingleOperation> quarantined) {
        int batchSize = this.writeBatchSize;
        if (quarantined.size() < batchSize) {
            batchSize = quarantined.size();
        }
        HashMap separatedItemsPerType = new HashMap();
        for (int i = 0; i < batchSize; ++i) {
            ArrayList<SingleOperation> itemsPerType;
            SingleOperation item = quarantined.get(i);
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(this.getThreadName() + " : processItems() : adding " + item + " to next batch");
            }
            if (null == (itemsPerType = (ArrayList<SingleOperation>)separatedItemsPerType.get(item.getClass()))) {
                itemsPerType = new ArrayList<SingleOperation>();
                separatedItemsPerType.put(item.getClass(), itemsPerType);
            }
            itemsPerType.add(item);
        }
        block5: for (List itemsPerType : separatedItemsPerType.values()) {
            int executionsLeft = this.retryAttempts + 1;
            while (executionsLeft-- > 0) {
                try {
                    ((SingleOperation)itemsPerType.get(0)).createBatchOperation(itemsPerType).performBatchOperation(this.cacheWriter);
                    continue block5;
                }
                catch (RuntimeException e) {
                    if (executionsLeft <= 0) {
                        throw e;
                    }
                    LOGGER.warning("Exception while processing write behind queue, retrying in " + this.retryAttemptDelaySeconds + " seconds, " + executionsLeft + " retries left : " + e.getMessage());
                    try {
                        Thread.sleep(this.retryAttemptDelaySeconds * 1000);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
            }
        }
        for (int i = 0; i < batchSize; ++i) {
            quarantined.remove(0);
        }
    }

    private void processSingleOperation(List<SingleOperation> quarantined) {
        SingleOperation item = quarantined.get(0);
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(this.getThreadName() + " : processItems() : processing " + item);
        }
        int executionsLeft = this.retryAttempts + 1;
        while (executionsLeft-- > 0) {
            try {
                item.performSingleOperation(this.cacheWriter);
                break;
            }
            catch (RuntimeException e) {
                if (executionsLeft <= 0) {
                    throw e;
                }
                LOGGER.warning("Exception while processing write behind queue, retrying in " + this.retryAttemptDelaySeconds + " seconds, " + executionsLeft + " retries left : " + e.getMessage());
                try {
                    Thread.sleep(this.retryAttemptDelaySeconds * 1000);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
            }
        }
        quarantined.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Element element) {
        this.queueWriteLock.lock();
        try {
            this.waiting.add(new WriteOperation(element));
            this.queueIsEmpty.signal();
        }
        finally {
            this.queueWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Object key) {
        this.queueWriteLock.lock();
        try {
            this.waiting.add(new DeleteOperation(key));
            this.queueIsEmpty.signal();
        }
        finally {
            this.queueWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.queueWriteLock.lock();
        try {
            this.cancelled = true;
            this.queueIsEmpty.signal();
        }
        finally {
            this.queueWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCancelled() {
        this.queueReadLock.lock();
        try {
            boolean bl = this.cancelled;
            return bl;
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    private String getThreadName() {
        return this.processingThread.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassemble(List<SingleOperation> quarantined) {
        this.queueWriteLock.lock();
        try {
            if (null == quarantined) {
                return;
            }
            quarantined.addAll(this.waiting);
            this.waiting = quarantined;
            this.queueIsEmpty.signal();
        }
        finally {
            this.queueWriteLock.unlock();
        }
    }

    private final class ProcessingThread
    implements Runnable {
        private ProcessingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!WriteBehindQueue.this.isCancelled()) {
                WriteBehindQueue.this.processItems();
                WriteBehindQueue.this.queueWriteLock.lock();
                try {
                    try {
                        long actualDelay;
                        long delay = WriteBehindQueue.this.minWriteDelayMs;
                        do {
                            WriteBehindQueue.this.queueIsEmpty.await(delay, TimeUnit.MILLISECONDS);
                        } while ((delay = (actualDelay = System.currentTimeMillis() - WriteBehindQueue.this.getLastProcessing()) < WriteBehindQueue.this.minWriteDelayMs ? WriteBehindQueue.this.minWriteDelayMs - actualDelay : 0L) > 0L);
                    }
                    catch (InterruptedException e) {
                        WriteBehindQueue.this.stop();
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    WriteBehindQueue.this.queueWriteLock.unlock();
                }
            }
        }
    }
}

