/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.util.HashSet;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.TransactionContext;
import net.sf.ehcache.transaction.xa.EhcacheXAException;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import net.sf.ehcache.transaction.xa.EhcacheXAStore;
import net.sf.ehcache.transaction.xa.VersionAwareCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheXAResourceImpl
implements EhcacheXAResource {
    private static final Logger LOG = LoggerFactory.getLogger((String)EhcacheXAResourceImpl.class.getName());
    private final String cacheName;
    private final EhcacheXAStore ehcacheXAStore;
    private int transactionTimeout;
    private Store store;
    private Store oldVersionStore;
    private TransactionManager txnManager;

    public EhcacheXAResourceImpl(String cacheName, Store store, TransactionManager txnManager, EhcacheXAStore ehcacheXAStore) {
        this.cacheName = cacheName;
        this.store = store;
        this.txnManager = txnManager;
        this.ehcacheXAStore = ehcacheXAStore;
        this.oldVersionStore = ehcacheXAStore.getOldVersionStore();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void start(Xid xid, int flags) throws XAException {
        Transaction tx;
        LOG.debug("Start called for Txn with id: " + xid);
        try {
            tx = this.txnManager.getTransaction();
        }
        catch (SystemException e) {
            throw new EhcacheXAException("Couldn't get to current Transaction: " + e.getMessage(), e.errorCode, e);
        }
        if (tx == null) {
            throw new EhcacheXAException("Couldn't get to current Transaction ", -9);
        }
        Xid prevXid = this.ehcacheXAStore.storeXid2Transaction(xid, tx);
        if (prevXid != null && !prevXid.equals(xid)) {
            throw new EhcacheXAException("Duplicated XID: " + xid, -8);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (onePhase) {
            this.prepare(xid);
        }
        LOG.debug("{} phase commit called for Txn with id: {}", (Object)(onePhase ? "One" : "Two"), (Object)xid);
        TransactionContext context = this.ehcacheXAStore.getTransactionContext(xid);
        Sync[] syncForKeys = ((CacheLockProvider)this.oldVersionStore.getInternalContext()).getAndWriteLockAllSyncForKeys(context.getUpdatedKeys().toArray());
        for (VersionAwareCommand command : context.getCommands()) {
            Object key = command.getKey();
            if (key == null) continue;
            this.ehcacheXAStore.checkin(key, xid, command.isWriteCommand());
            this.oldVersionStore.remove(key);
            ((CacheLockProvider)this.store.getInternalContext()).getSyncForKey(key).unlock(LockType.WRITE);
        }
        for (Sync syncForKey : syncForKeys) {
            syncForKey.unlock(LockType.WRITE);
        }
        this.ehcacheXAStore.removeData(xid);
    }

    public void end(Xid xid, int flags) throws XAException {
        LOG.debug("End called for Txn with id: {}", (Object)xid);
    }

    public void forget(Xid xid) throws XAException {
        LOG.debug("Forget called for Txn with id: {}", (Object)xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        LOG.debug("Prepare called for Txn with id: {}", (Object)xid);
        TransactionContext context = this.ehcacheXAStore.getTransactionContext(xid);
        CacheLockProvider storeLockProvider = (CacheLockProvider)this.store.getInternalContext();
        CacheLockProvider oldVersionStoreLockProvider = (CacheLockProvider)this.oldVersionStore.getInternalContext();
        this.validateCommands(context);
        HashSet<Object> keys = new HashSet<Object>();
        for (VersionAwareCommand command : context.getCommands()) {
            Object key = command.getKey();
            if (key == null) continue;
            Sync syncForKey = oldVersionStoreLockProvider.getSyncForKey(key);
            syncForKey.lock(LockType.WRITE);
            try {
                if (!this.ehcacheXAStore.isValid(command)) {
                    for (Object e : keys) {
                        this.oldVersionStore.remove(e);
                    }
                    throw new EhcacheXAException("Invalid version for element: " + command.getKey(), 103);
                }
                keys.add(key);
                this.oldVersionStore.put(this.store.get(key));
            }
            finally {
                syncForKey.unlock(LockType.WRITE);
            }
        }
        Sync[] syncForKeys = storeLockProvider.getAndWriteLockAllSyncForKeys(keys.toArray());
        LOG.debug("Locked {} syncs for {} keys", (Object)(syncForKeys == null ? 0 : syncForKeys.length), (Object)keys.size());
        this.ehcacheXAStore.prepared(xid);
        boolean writes = false;
        for (VersionAwareCommand command : context.getCommands()) {
            writes = command.execute(this.store) || writes;
        }
        return writes ? 0 : 3;
    }

    private void validateCommands(TransactionContext context) throws XAException {
        for (VersionAwareCommand command : context.getCommands()) {
            if (!command.isVersionAware() || this.ehcacheXAStore.isValid(command)) continue;
            throw new EhcacheXAException("Invalid version for element: " + command.getKey(), 103);
        }
    }

    public Xid[] recover(int i) throws XAException {
        return this.ehcacheXAStore.getPreparedXids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        LOG.debug("Rollback called for Txn with id: {}", (Object)xid);
        TransactionContext context = this.ehcacheXAStore.getTransactionContext(xid);
        if (this.ehcacheXAStore.isPrepared(xid)) {
            CacheLockProvider storeLockProvider = (CacheLockProvider)this.store.getInternalContext();
            CacheLockProvider oldVersionStoreLockProvider = (CacheLockProvider)this.oldVersionStore.getInternalContext();
            for (VersionAwareCommand command : context.getCommands()) {
                Object key = command.getKey();
                if (key == null) continue;
                Sync syncForKey = oldVersionStoreLockProvider.getSyncForKey(key);
                syncForKey.lock(LockType.WRITE);
                Element element = null;
                try {
                    element = this.oldVersionStore.remove(key);
                    if (element != null) {
                        this.store.put(element);
                        continue;
                    }
                    LOG.error("No element found in oldVersionStore for key '{}'", key);
                }
                finally {
                    syncForKey.unlock(LockType.WRITE);
                    if (element != null) {
                        storeLockProvider.getSyncForKey(key).unlock(LockType.WRITE);
                    }
                }
            }
        }
        this.ehcacheXAStore.removeData(xid);
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this == xaResource;
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        this.transactionTimeout = i;
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public Store getStore() {
        return this.store;
    }

    public boolean equals(Object obj) {
        EhcacheXAResource resource2 = (EhcacheXAResource)obj;
        return this.cacheName.equals(resource2.getCacheName());
    }

    public int hashCode() {
        return this.cacheName.hashCode();
    }

    public TransactionContext getOrCreateTransactionContext() throws SystemException, RollbackException {
        Transaction transaction = this.txnManager.getTransaction();
        if (transaction == null) {
            throw new CacheException("Cache " + this.cacheName + " can only be accessed within a JTA Transaction!");
        }
        if (transaction.getStatus() != 0) {
            throw new CacheException("Transaction not active!");
        }
        TransactionContext context = this.ehcacheXAStore.getTransactionContext(transaction);
        if (context == null) {
            transaction.enlistResource((XAResource)this);
            context = this.ehcacheXAStore.createTransactionContext(transaction);
        }
        return context;
    }

    public Element get(Object key) {
        Element element = this.oldVersionStore.get(key);
        if (element == null) {
            element = this.store.get(key);
        }
        return element;
    }

    public Element getQuiet(Object key) {
        Element element = this.oldVersionStore.getQuiet(key);
        if (element == null) {
            element = this.store.getQuiet(key);
        }
        return element;
    }
}

