/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.manager;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;

public class DefaultTransactionManagerLookup
implements TransactionManagerLookup {
    private transient TransactionManager transactionManager;
    private transient String vendor;
    private transient Properties properties = new Properties();
    private final Lock lock = new ReentrantLock();
    private final Selector[] transactionManagerSelectors = new Selector[]{new JndiSelector("genericJNDI", "java:/TransactionManager"), new FactorySelector("WebSphere 5.1", "com.ibm.ws.Transaction.TransactionManagerFactory"), new FactorySelector("Bitronix", "bitronix.tm.TransactionManagerServices"), new ClassSelector("Atomikos", "com.atomikos.icatch.jta.UserTransactionManager")};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.lock.lock();
            try {
                if (this.transactionManager == null) {
                    this.lookupTransactionManager();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.transactionManager;
    }

    public void register(EhcacheXAResource resource) {
        if (this.vendor.equals("Bitronix")) {
            this.registerResourceWithBitronix(resource.getCacheName(), resource);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private void registerResourceWithBitronix(String uniqueName, EhcacheXAResource resource) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> producerClass = cl.loadClass("net.sf.ehcache.transaction.manager.btm.GenericXAResourceProducer");
            Class[] signature = new Class[]{String.class, XAResource.class};
            Object[] args = new Object[]{uniqueName, resource};
            Method method = producerClass.getMethod("registerXAResource", signature);
            method.invoke(null, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lookupTransactionManager() {
        try {
            InitialContext context = new InitialContext();
            for (Selector selector : this.transactionManagerSelectors) {
                this.transactionManager = selector.lookup(context);
                if (this.transactionManager == null) continue;
                this.vendor = selector.getVendor();
                return;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private static final class ClassSelector
    extends Selector {
        private final String classname;

        private ClassSelector(String vendor, String classname) {
            super(vendor);
            this.classname = classname;
        }

        protected TransactionManager lookup(InitialContext initialContext) {
            TransactionManager transactionManager = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> txManagerClass = cl.loadClass(this.classname);
                transactionManager = (TransactionManager)txManagerClass.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
            return transactionManager;
        }
    }

    private static final class FactorySelector
    extends Selector {
        private final String factoryClassName;
        private final boolean isStatic = true;

        private FactorySelector(String vendor, String factoryClassName) {
            super(vendor);
            this.factoryClassName = factoryClassName;
        }

        protected TransactionManager lookup(InitialContext initialContext) {
            TransactionManager transactionManager = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> factoryClass = cl.loadClass(this.factoryClassName);
                Class<?>[] signature = null;
                Object[] args = null;
                Method method = factoryClass.getMethod("getTransactionManager", signature);
                transactionManager = (TransactionManager)method.invoke(null, args);
            }
            catch (Exception e) {
                // empty catch block
            }
            return transactionManager;
        }
    }

    private static final class JndiSelector
    extends Selector {
        private final String jndiName;

        private JndiSelector(String vendor, String jndiName) {
            super(vendor);
            this.jndiName = jndiName;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        protected TransactionManager lookup(InitialContext initialContext) {
            try {
                Object jndiObject = initialContext.lookup(this.getJndiName());
                if (jndiObject instanceof TransactionManager) {
                    return (TransactionManager)jndiObject;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            return null;
        }
    }

    private static abstract class Selector {
        private final String vendor;

        protected Selector(String vendor) {
            this.vendor = vendor;
        }

        public String getVendor() {
            return this.vendor;
        }

        protected abstract TransactionManager lookup(InitialContext var1);
    }
}

