/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.util.ProductInfo;

public class UpdateChecker
extends TimerTask {
    private static final Logger LOG = Logger.getLogger(UpdateChecker.class.getName());
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final String NOT_AVAILABLE = "UNKNOWN";
    private static final String UPDATE_CHECK_URL = "http://www.terracotta.org/kit/reflector?kitID=ehcache.default&pageID=update.properties";
    private static final long START_TIME = System.currentTimeMillis();

    public void run() {
        this.checkForUpdate();
    }

    public void checkForUpdate() {
        try {
            if (!Boolean.getBoolean("net.sf.ehcache.skipUpdateCheck")) {
                this.doCheck();
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Update check failed: " + t.toString());
        }
    }

    private void doCheck() throws IOException {
        LOG.log(Level.FINE, "Checking for update...");
        URL updateUrl = this.buildUpdateCheckUrl();
        Properties updateProps = this.getUpdateProperties(updateUrl);
        String currentVersion = new ProductInfo().getVersion();
        String propVal = updateProps.getProperty("general.notice");
        if (this.notBlank(propVal)) {
            LOG.log(Level.INFO, propVal);
        }
        if (this.notBlank(propVal = updateProps.getProperty(currentVersion + ".notice"))) {
            LOG.log(Level.INFO, propVal);
        }
        if (this.notBlank(propVal = updateProps.getProperty(currentVersion + ".updates"))) {
            StringBuilder sb = new StringBuilder();
            String[] newVersions = propVal.split(",");
            for (int i = 0; i < newVersions.length; ++i) {
                String newVersion = newVersions[i].trim();
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(newVersion);
                propVal = updateProps.getProperty(newVersion + ".release-notes");
                if (!this.notBlank(propVal)) continue;
                sb.append(" [");
                sb.append(propVal);
                sb.append("]");
            }
            if (sb.length() > 0) {
                LOG.log(Level.INFO, "New update(s) found: " + sb.toString());
            }
        } else {
            LOG.log(Level.FINE, "No update found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getUpdateProperties(URL updateUrl) throws IOException {
        URLConnection connection = updateUrl.openConnection();
        InputStream in = connection.getInputStream();
        try {
            Properties props = new Properties();
            props.load(connection.getInputStream());
            Properties properties = props;
            return properties;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private URL buildUpdateCheckUrl() throws MalformedURLException, UnsupportedEncodingException {
        String url = System.getProperty("ehcache.update-check.url", UPDATE_CHECK_URL);
        String connector = url.indexOf(63) > 0 ? "&" : "?";
        return new URL(url + connector + this.buildParamsString());
    }

    private String buildParamsString() throws UnsupportedEncodingException {
        ProductInfo productInfo = new ProductInfo();
        StringBuilder sb = new StringBuilder();
        sb.append("id=");
        sb.append(this.getClientId());
        sb.append("&os-name=");
        sb.append(this.urlEncode(this.getProperty("os.name")));
        sb.append("&jvm-name=");
        sb.append(this.urlEncode(this.getProperty("java.vm.name")));
        sb.append("&jvm-version=");
        sb.append(this.urlEncode(this.getProperty("java.version")));
        sb.append("&platform=");
        sb.append(this.urlEncode(this.getProperty("os.arch")));
        sb.append("&tc-version=");
        sb.append(NOT_AVAILABLE);
        sb.append("&tc-product=");
        sb.append(this.urlEncode(productInfo.getName() + " " + productInfo.getVersion()));
        sb.append("&source=");
        sb.append(this.urlEncode(productInfo.getName()));
        sb.append("&uptime-secs=");
        sb.append(this.getUptimeInSeconds());
        sb.append("&patch=");
        sb.append(this.urlEncode(productInfo.getPatchLevel()));
        return sb.toString();
    }

    private long getUptimeInSeconds() {
        long uptime = System.currentTimeMillis() - START_TIME;
        return uptime > 0L ? uptime / 1000L : 0L;
    }

    private int getClientId() {
        try {
            return InetAddress.getLocalHost().hashCode();
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private String urlEncode(String param) throws UnsupportedEncodingException {
        return URLEncoder.encode(param, "UTF-8");
    }

    private String getProperty(String prop) {
        return System.getProperty(prop, NOT_AVAILABLE);
    }

    private boolean notBlank(String s) {
        return s != null && s.trim().length() > 0;
    }
}

