/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.provider;

import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.management.provider.MBeanRegistrationProvider;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderFactory;
import net.sf.ehcache.management.provider.NullMBeanRegistrationProvider;
import net.sf.ehcache.management.sampled.SampledMBeanRegistrationProvider;

public class MBeanRegistrationProviderFactoryImpl
implements MBeanRegistrationProviderFactory {
    private static final MBeanRegistrationProvider DEFAULT_PROVIDER = new NullMBeanRegistrationProvider();

    public MBeanRegistrationProvider createMBeanRegistrationProvider(Configuration config) {
        if (null == config) {
            throw new IllegalArgumentException("Configuration cannot be null.");
        }
        MBeanRegistrationProvider provider = this.shouldRegisterMBeans(config) ? new SampledMBeanRegistrationProvider() : DEFAULT_PROVIDER;
        return provider;
    }

    private boolean shouldRegisterMBeans(Configuration config) {
        Configuration.Monitoring monitoring = config.getMonitoring();
        switch (monitoring) {
            case AUTODETECT: {
                return this.isTcActive();
            }
            case ON: {
                return true;
            }
            case OFF: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown type of monitoring specified in config: " + (Object)((Object)monitoring));
    }

    private boolean isTcActive() {
        return Boolean.getBoolean("tc.active");
    }
}

