/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.Status;
import net.sf.ehcache.TerracottaStoreHelper;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import net.sf.ehcache.management.provider.MBeanRegistrationProvider;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderException;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderFactory;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderFactoryImpl;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreFactory;
import net.sf.ehcache.util.FailSafeTimer;
import net.sf.ehcache.util.PropertyUtil;
import net.sf.ehcache.util.UpdateChecker;

public class CacheManager {
    public static final List<CacheManager> ALL_CACHE_MANAGERS = new CopyOnWriteArrayList<CacheManager>();
    public static final String ENABLE_SHUTDOWN_HOOK_PROPERTY = "net.sf.ehcache.enableShutdownHook";
    private static final Logger LOG = Logger.getLogger(CacheManager.class.getName());
    private static final long EVERY_WEEK = 604800000L;
    private static CacheManager singleton;
    private static MBeanRegistrationProviderFactory mBeanRegistrationProviderFactory;
    protected final Map ehcaches = new ConcurrentHashMap();
    protected final Map caches = new ConcurrentHashMap();
    protected String name;
    protected Status status;
    protected Map<String, CacheManagerPeerProvider> cacheManagerPeerProviders = new ConcurrentHashMap<String, CacheManagerPeerProvider>();
    protected Map<String, CacheManagerPeerListener> cacheManagerPeerListeners = new ConcurrentHashMap<String, CacheManagerPeerListener>();
    protected CacheManagerEventListenerRegistry cacheManagerEventListenerRegistry = new CacheManagerEventListenerRegistry();
    protected Thread shutdownHook;
    private Ehcache defaultCache;
    private String diskStorePath;
    private MBeanRegistrationProvider mbeanRegistrationProvider;
    private FailSafeTimer cacheManagerTimer;
    private StoreFactory terracottaStoreFactory;

    public CacheManager(Configuration configuration) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(configuration, null, null, null);
    }

    public CacheManager(String configurationFileName) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, configurationFileName, null, null);
    }

    public CacheManager(URL configurationURL) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, configurationURL, null);
    }

    public CacheManager(InputStream configurationInputStream) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, null, configurationInputStream);
    }

    public CacheManager() throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, null, null);
    }

    protected void init(Configuration configuration, String configurationFileName, URL configurationURL, InputStream configurationInputStream) {
        Configuration localConfiguration = configuration;
        if (configuration == null) {
            localConfiguration = this.parseConfiguration(configurationFileName, configurationURL, configurationInputStream);
        } else {
            localConfiguration.setSource("Programmatically configured.");
        }
        if (localConfiguration.getName() != null) {
            this.name = localConfiguration.getName();
        }
        Map cacheConfigs = localConfiguration.getCacheConfigurations();
        for (CacheConfiguration config : cacheConfigs.values()) {
            if (!config.isTerracottaClustered()) continue;
            this.terracottaStoreFactory = TerracottaStoreHelper.newStoreFactory(cacheConfigs, localConfiguration.getTerracottaConfiguration());
            break;
        }
        if (this.terracottaStoreFactory == null && localConfiguration.getDefaultCacheConfiguration().isTerracottaClustered()) {
            this.terracottaStoreFactory = TerracottaStoreHelper.newStoreFactory(cacheConfigs, localConfiguration.getTerracottaConfiguration());
        }
        ConfigurationHelper configurationHelper = new ConfigurationHelper(this, localConfiguration);
        this.configure(configurationHelper);
        this.status = Status.STATUS_ALIVE;
        for (CacheManagerPeerProvider cacheManagerPeerProvider : this.cacheManagerPeerProviders.values()) {
            cacheManagerPeerProvider.init();
        }
        this.cacheManagerEventListenerRegistry.init();
        this.addShutdownHookIfRequired();
        this.cacheManagerTimer = new FailSafeTimer(this.getName());
        this.checkForUpdateIfNeeded(localConfiguration.getUpdateCheck());
        this.addConfiguredCaches(configurationHelper);
        this.mbeanRegistrationProvider = mBeanRegistrationProviderFactory.createMBeanRegistrationProvider(localConfiguration);
        try {
            this.mbeanRegistrationProvider.initialize(this);
        }
        catch (MBeanRegistrationProviderException e) {
            LOG.log(Level.WARNING, "Failed to initialize the MBeanRegistrationProvider - " + this.mbeanRegistrationProvider.getClass().getName(), e);
        }
    }

    Store createTerracottaStore(Ehcache cache) {
        if (this.terracottaStoreFactory == null) {
            throw new CacheException("no terracotta configuration has been initalized for this cache manager");
        }
        return this.terracottaStoreFactory.create(cache);
    }

    private void checkForUpdateIfNeeded(boolean updateCheckNeeded) {
        try {
            if (updateCheckNeeded) {
                UpdateChecker updateChecker = new UpdateChecker();
                this.cacheManagerTimer.scheduleAtFixedRate((TimerTask)updateChecker, 1L, 604800000L);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Failed to set up update checker: " + t.toString());
        }
    }

    private synchronized Configuration parseConfiguration(String configurationFileName, URL configurationURL, InputStream configurationInputStream) throws CacheException {
        String configurationSource;
        Configuration configuration;
        this.reinitialisationCheck();
        if (configurationFileName != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Configuring CacheManager from " + configurationFileName);
            }
            configuration = ConfigurationFactory.parseConfiguration(new File(configurationFileName));
            configurationSource = "file located at " + configurationFileName;
        } else if (configurationURL != null) {
            configuration = ConfigurationFactory.parseConfiguration(configurationURL);
            configurationSource = "URL of " + configurationURL;
        } else if (configurationInputStream != null) {
            configuration = ConfigurationFactory.parseConfiguration(configurationInputStream);
            configurationSource = "InputStream " + configurationInputStream;
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Configuring ehcache from classpath.");
            }
            configuration = ConfigurationFactory.parseConfiguration();
            configurationSource = "classpath";
        }
        configuration.setSource(configurationSource);
        return configuration;
    }

    private void configure(ConfigurationHelper configurationHelper) {
        this.diskStorePath = configurationHelper.getDiskStorePath();
        int cachesRequiringDiskStores = configurationHelper.numberOfCachesThatOverflowToDisk() + configurationHelper.numberOfCachesThatAreDiskPersistent();
        if (this.diskStorePath == null && cachesRequiringDiskStores > 0) {
            this.diskStorePath = DiskStoreConfiguration.getDefaultPath();
            LOG.log(Level.WARNING, "One or more caches require a DiskStore but there is no diskStore element configured. Using the default disk store path of " + DiskStoreConfiguration.getDefaultPath() + ". Please explicitly configure the diskStore element in ehcache.xml.");
        }
        this.detectAndFixDiskStorePathConflict(configurationHelper);
        this.cacheManagerEventListenerRegistry.registerListener(configurationHelper.createCacheManagerEventListener());
        this.cacheManagerPeerListeners = configurationHelper.createCachePeerListeners();
        for (CacheManagerPeerListener cacheManagerPeerListener : this.cacheManagerPeerListeners.values()) {
            this.cacheManagerEventListenerRegistry.registerListener(cacheManagerPeerListener);
        }
        this.detectAndFixCacheManagerPeerListenerConflict(configurationHelper);
        ALL_CACHE_MANAGERS.add(this);
        this.cacheManagerPeerProviders = configurationHelper.createCachePeerProviders();
        this.defaultCache = configurationHelper.createDefaultCache();
    }

    private void detectAndFixDiskStorePathConflict(ConfigurationHelper configurationHelper) {
        if (this.diskStorePath == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "No disk store path defined. Skipping disk store path conflict test.");
            }
            return;
        }
        for (CacheManager cacheManager : ALL_CACHE_MANAGERS) {
            if (!this.diskStorePath.equals(cacheManager.diskStorePath)) continue;
            String newDiskStorePath = this.diskStorePath + File.separator + DiskStore.generateUniqueDirectory();
            LOG.log(Level.WARNING, "Creating a new instance of CacheManager using the diskStorePath \"" + this.diskStorePath + "\" which is already used" + " by an existing CacheManager.\nThe source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "The diskStore path for this CacheManager will be set to " + newDiskStorePath + ".\nTo avoid this" + " warning consider using the CacheManager factory methods to create a singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance.");
            this.diskStorePath = newDiskStorePath;
            break;
        }
    }

    private void detectAndFixCacheManagerPeerListenerConflict(ConfigurationHelper configurationHelper) {
        if (this.cacheManagerPeerListeners == null) {
            return;
        }
        for (CacheManagerPeerListener cacheManagerPeerListener : this.cacheManagerPeerListeners.values()) {
            String uniqueResourceIdentifier = cacheManagerPeerListener.getUniqueResourceIdentifier();
            block1: for (CacheManager cacheManager : ALL_CACHE_MANAGERS) {
                for (CacheManagerPeerListener otherCacheManagerPeerListener : cacheManager.cacheManagerPeerListeners.values()) {
                    String otherUniqueResourceIdentifier;
                    if (otherCacheManagerPeerListener == null || !uniqueResourceIdentifier.equals(otherUniqueResourceIdentifier = otherCacheManagerPeerListener.getUniqueResourceIdentifier())) continue;
                    LOG.log(Level.WARNING, "Creating a new instance of CacheManager with a CacheManagerPeerListener which has a conflict on a resource that must be unique.\nThe resource is " + uniqueResourceIdentifier + ".\n" + "Attempting automatic resolution. The source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "To avoid this warning consider using the CacheManager factory methods to create a " + "singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance.");
                    cacheManagerPeerListener.attemptResolutionOfUniqueResourceConflict();
                    continue block1;
                }
            }
        }
    }

    private void addConfiguredCaches(ConfigurationHelper configurationHelper) {
        Set unitialisedCaches = configurationHelper.createCaches();
        for (Ehcache unitialisedCache : unitialisedCaches) {
            this.addCacheNoCheck(unitialisedCache);
        }
    }

    private void reinitialisationCheck() throws IllegalStateException {
        if (this.defaultCache != null || this.diskStorePath != null || this.ehcaches.size() != 0 || this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("Attempt to reinitialise the CacheManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create() throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Creating new CacheManager with default config");
                }
                singleton = new CacheManager();
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Attempting to create an existing singleton. Existing singleton returned.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static CacheManager getInstance() throws CacheException {
        return CacheManager.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(String configurationFileName) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Creating new CacheManager with config file: " + configurationFileName);
                }
                singleton = new CacheManager(configurationFileName);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(URL configurationFileURL) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Creating new CacheManager with config URL: " + configurationFileURL);
                }
                singleton = new CacheManager(configurationFileURL);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(InputStream inputStream) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Creating new CacheManager with InputStream");
                }
                singleton = new CacheManager(inputStream);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public Cache getCache(String name) throws IllegalStateException, ClassCastException {
        this.checkStatus();
        return (Cache)this.caches.get(name);
    }

    public Ehcache getEhcache(String name) throws IllegalStateException {
        this.checkStatus();
        return (Ehcache)this.ehcaches.get(name);
    }

    private void addShutdownHookIfRequired() {
        String shutdownHookProperty = System.getProperty(ENABLE_SHUTDOWN_HOOK_PROPERTY);
        boolean enabled = PropertyUtil.parseBoolean(shutdownHookProperty);
        if (!enabled) {
            return;
        }
        LOG.log(Level.INFO, "The CacheManager shutdown hook is enabled because net.sf.ehcache.enableShutdownHook is set to true.");
        Thread localShutdownHook = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (CacheManager.this.status.equals(Status.STATUS_ALIVE)) {
                        CacheManager.this.shutdownHook = null;
                        if (LOG.isLoggable(Level.INFO)) {
                            LOG.log(Level.INFO, "VM shutting down with the CacheManager still active. Calling shutdown.");
                        }
                        CacheManager.this.shutdown();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(localShutdownHook);
        this.shutdownHook = localShutdownHook;
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            block3: {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.log(Level.FINE, "IllegalStateException due to attempt to remove a shutdownhook while the VM is actually shutting down.", e);
                }
            }
            this.shutdownHook = null;
        }
    }

    public void addCache(String cacheName) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        if (this.ehcaches.get(cacheName) != null) {
            throw new ObjectExistsException("Cache " + cacheName + " already exists");
        }
        Ehcache cache = null;
        try {
            cache = (Ehcache)this.defaultCache.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Failure adding cache. Initial cause was " + e.getMessage(), e);
        }
        if (cache != null) {
            cache.setName(cacheName);
        }
        this.addCache(cache);
    }

    public void addCache(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cache == null) {
            return;
        }
        this.addCache((Ehcache)cache);
        this.caches.put(cache.getName(), cache);
    }

    public void addCache(Ehcache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cache == null) {
            return;
        }
        this.addCacheNoCheck(cache);
    }

    private void addCacheNoCheck(Ehcache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        if (this.ehcaches.get(cache.getName()) != null) {
            throw new ObjectExistsException("Cache " + cache.getName() + " already exists");
        }
        cache.setCacheManager(this);
        cache.setDiskStorePath(this.diskStorePath);
        cache.initialise();
        try {
            cache.bootstrap();
        }
        catch (CacheException e) {
            LOG.log(Level.WARNING, "Cache " + cache.getName() + "requested bootstrap but a CacheException occured. " + e.getMessage(), e);
        }
        this.ehcaches.put(cache.getName(), cache);
        if (cache instanceof Cache) {
            this.caches.put(cache.getName(), cache);
        }
        if (this.status.equals(Status.STATUS_ALIVE)) {
            this.cacheManagerEventListenerRegistry.notifyCacheAdded(cache.getName());
        }
    }

    public boolean cacheExists(String cacheName) throws IllegalStateException {
        this.checkStatus();
        return this.ehcaches.get(cacheName) != null;
    }

    public void removalAll() {
        String[] cacheNames;
        for (String cacheName : cacheNames = this.getCacheNames()) {
            this.removeCache(cacheName);
        }
    }

    public void removeCache(String cacheName) throws IllegalStateException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        Ehcache cache = (Ehcache)this.ehcaches.remove(cacheName);
        if (cache != null && cache.getStatus().equals(Status.STATUS_ALIVE)) {
            cache.dispose();
            this.cacheManagerEventListenerRegistry.notifyCacheRemoved(cache.getName());
        }
        this.caches.remove(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "CacheManager already shutdown");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            for (CacheManagerPeerProvider cacheManagerPeerProvider : this.cacheManagerPeerProviders.values()) {
                if (cacheManagerPeerProvider == null) continue;
                cacheManagerPeerProvider.dispose();
            }
            if (this.cacheManagerTimer != null) {
                this.cacheManagerTimer.cancel();
                this.cacheManagerTimer.purge();
            }
            this.cacheManagerEventListenerRegistry.dispose();
            Class<CacheManager> clazz2 = CacheManager.class;
            synchronized (CacheManager.class) {
                ALL_CACHE_MANAGERS.remove(this);
                Collection cacheSet = this.ehcaches.values();
                for (Ehcache cache : cacheSet) {
                    if (cache == null) continue;
                    cache.dispose();
                }
                this.defaultCache.dispose();
                this.status = Status.STATUS_SHUTDOWN;
                if (this == singleton) {
                    singleton = null;
                }
                this.removeShutdownHook();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    public String[] getCacheNames() throws IllegalStateException {
        this.checkStatus();
        String[] list = new String[this.ehcaches.size()];
        return this.ehcaches.keySet().toArray(list);
    }

    protected void checkStatus() {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            if (this.status.equals(Status.STATUS_UNINITIALISED)) {
                throw new IllegalStateException("The CacheManager has not yet been initialised. It cannot be used yet.");
            }
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                throw new IllegalStateException("The CacheManager has been shut down. It can no longer be used.");
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void clearAll() throws CacheException {
        String[] cacheNames = this.getCacheNames();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Clearing all caches");
        }
        for (String cacheName : cacheNames) {
            Ehcache cache = this.getEhcache(cacheName);
            cache.removeAll();
        }
    }

    public CacheManagerPeerProvider getCacheManagerPeerProvider(String scheme) {
        return this.cacheManagerPeerProviders.get(scheme);
    }

    public CacheManagerPeerListener getCachePeerListener(String scheme) {
        return this.cacheManagerPeerListeners.get(scheme);
    }

    public CacheManagerEventListener getCacheManagerEventListener() {
        return this.cacheManagerEventListenerRegistry;
    }

    public void setCacheManagerEventListener(CacheManagerEventListener cacheManagerEventListener) {
        this.getCacheManagerEventListenerRegistry().registerListener(cacheManagerEventListener);
    }

    public CacheManagerEventListenerRegistry getCacheManagerEventListenerRegistry() {
        return this.cacheManagerEventListenerRegistry;
    }

    public void replaceCacheWithDecoratedCache(Ehcache ehcache, Ehcache decoratedCache) throws CacheException {
        if (!ehcache.equals(decoratedCache)) {
            throw new CacheException("Cannot replace " + decoratedCache.getName() + " It does not equal the incumbent cache.");
        }
        String cacheName = ehcache.getName();
        this.ehcaches.remove(cacheName);
        this.caches.remove(cacheName);
        this.ehcaches.put(decoratedCache.getName(), decoratedCache);
        if (decoratedCache instanceof Cache) {
            this.caches.put(decoratedCache.getName(), decoratedCache);
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public void setName(String name) {
        this.name = name;
        try {
            this.mbeanRegistrationProvider.reinitialize();
        }
        catch (MBeanRegistrationProviderException e) {
            throw new CacheException("Problem in reinitializing MBeanRegistrationProvider - " + this.mbeanRegistrationProvider.getClass().getName(), e);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getDiskStorePath() {
        return this.diskStorePath;
    }

    public FailSafeTimer getTimer() {
        return this.cacheManagerTimer;
    }

    static {
        mBeanRegistrationProviderFactory = new MBeanRegistrationProviderFactoryImpl();
    }
}

