/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.terracotta.shaded.lucene.store.AlreadyClosedException;

public abstract class ReferenceManager<G>
implements Closeable {
    private static final String REFERENCE_MANAGER_IS_CLOSED_MSG = "this ReferenceManager is closed";
    protected volatile G current;
    private final Lock refreshLock = new ReentrantLock();

    private void ensureOpen() {
        if (this.current == null) {
            throw new AlreadyClosedException(REFERENCE_MANAGER_IS_CLOSED_MSG);
        }
    }

    private synchronized void swapReference(G newReference) throws IOException {
        this.ensureOpen();
        G oldReference = this.current;
        this.current = newReference;
        this.release(oldReference);
    }

    protected abstract void decRef(G var1) throws IOException;

    protected abstract G refreshIfNeeded(G var1) throws IOException;

    protected abstract boolean tryIncRef(G var1);

    public final G acquire() {
        G ref;
        do {
            if ((ref = this.current) != null) continue;
            throw new AlreadyClosedException(REFERENCE_MANAGER_IS_CLOSED_MSG);
        } while (!this.tryIncRef(ref));
        return ref;
    }

    @Override
    public final synchronized void close() throws IOException {
        if (this.current != null) {
            this.swapReference(null);
            this.afterClose();
        }
    }

    protected void afterClose() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMaybeRefresh() throws IOException {
        this.refreshLock.lock();
        try {
            block11: {
                G reference = this.acquire();
                try {
                    G newReference = this.refreshIfNeeded(reference);
                    if (newReference == null) break block11;
                    assert (newReference != reference) : "refreshIfNeeded should return null if refresh wasn't needed";
                    boolean success = false;
                    try {
                        this.swapReference(newReference);
                        success = true;
                    }
                    finally {
                        if (!success) {
                            this.release(newReference);
                        }
                    }
                }
                finally {
                    this.release(reference);
                }
            }
            this.afterRefresh();
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean maybeRefresh() throws IOException {
        this.ensureOpen();
        boolean doTryRefresh = this.refreshLock.tryLock();
        if (doTryRefresh) {
            try {
                this.doMaybeRefresh();
            }
            finally {
                this.refreshLock.unlock();
            }
        }
        return doTryRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void maybeRefreshBlocking() throws IOException {
        this.ensureOpen();
        this.refreshLock.lock();
        try {
            this.doMaybeRefresh();
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    protected void afterRefresh() throws IOException {
    }

    public final void release(G reference) throws IOException {
        assert (reference != null);
        this.decRef(reference);
    }
}

