/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import org.terracotta.shaded.lucene.codecs.DocValuesConsumer;
import org.terracotta.shaded.lucene.index.DocInverterPerField;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.index.DocumentsWriterPerThread;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.FieldInvertState;
import org.terracotta.shaded.lucene.index.IndexableField;
import org.terracotta.shaded.lucene.index.InvertedDocEndConsumerPerField;
import org.terracotta.shaded.lucene.index.Norm;
import org.terracotta.shaded.lucene.index.NormsConsumer;
import org.terracotta.shaded.lucene.search.similarities.Similarity;

final class NormsConsumerPerField
extends InvertedDocEndConsumerPerField
implements Comparable<NormsConsumerPerField> {
    private final FieldInfo fieldInfo;
    private final DocumentsWriterPerThread.DocState docState;
    private final Similarity similarity;
    private final FieldInvertState fieldState;
    private DocValuesConsumer consumer;
    private final Norm norm;
    private final NormsConsumer parent;
    private DocValues.Type initType;

    public NormsConsumerPerField(DocInverterPerField docInverterPerField, FieldInfo fieldInfo, NormsConsumer parent) {
        this.fieldInfo = fieldInfo;
        this.parent = parent;
        this.docState = docInverterPerField.docState;
        this.fieldState = docInverterPerField.fieldState;
        this.similarity = this.docState.similarity;
        this.norm = new Norm();
    }

    @Override
    public int compareTo(NormsConsumerPerField other) {
        return this.fieldInfo.name.compareTo(other.fieldInfo.name);
    }

    @Override
    void finish() throws IOException {
        if (this.fieldInfo.isIndexed() && !this.fieldInfo.omitsNorms()) {
            this.similarity.computeNorm(this.fieldState, this.norm);
            if (this.norm.type() != null) {
                IndexableField field = this.norm.field();
                DocValuesConsumer consumer = this.getConsumer(this.norm.type());
                consumer.add(this.docState.docID, field);
            }
        }
    }

    DocValues.Type flush(int docCount) throws IOException {
        if (!this.initialized()) {
            return null;
        }
        this.consumer.finish(docCount);
        return this.initType;
    }

    private DocValuesConsumer getConsumer(DocValues.Type type) throws IOException {
        if (this.consumer == null) {
            assert (this.fieldInfo.getNormType() == null || this.fieldInfo.getNormType() == type);
            this.fieldInfo.setNormValueType(type);
            this.consumer = this.parent.newConsumer(this.docState.docWriter.newPerDocWriteState(""), this.fieldInfo, type);
            this.initType = type;
        }
        if (this.initType != type) {
            throw new IllegalArgumentException("NormTypes for field: " + this.fieldInfo.name + " doesn't match " + (Object)((Object)this.initType) + " != " + (Object)((Object)type));
        }
        return this.consumer;
    }

    boolean initialized() {
        return this.consumer != null;
    }

    @Override
    void abort() {
    }
}

