/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.codecs.lucene40;

import java.io.IOException;
import org.terracotta.shaded.lucene.codecs.CodecUtil;
import org.terracotta.shaded.lucene.codecs.FieldInfosWriter;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.FieldInfos;
import org.terracotta.shaded.lucene.index.IndexFileNames;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.store.IndexOutput;
import org.terracotta.shaded.lucene.util.IOUtils;

public class Lucene40FieldInfosWriter
extends FieldInfosWriter {
    static final String FIELD_INFOS_EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene40FieldInfos";
    static final int FORMAT_START = 0;
    static final int FORMAT_CURRENT = 0;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte STORE_OFFSETS_IN_POSTINGS = 4;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    static final byte OMIT_POSITIONS = -128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Directory directory, String segmentName, FieldInfos infos, IOContext context) throws IOException {
        block17: {
            IndexOutput output;
            block16: {
                String fileName = IndexFileNames.segmentFileName(segmentName, "", FIELD_INFOS_EXTENSION);
                output = directory.createOutput(fileName, context);
                boolean success = false;
                try {
                    CodecUtil.writeHeader(output, CODEC_NAME, 0);
                    output.writeVInt(infos.size());
                    for (FieldInfo fi : infos) {
                        FieldInfo.IndexOptions indexOptions = fi.getIndexOptions();
                        byte bits = 0;
                        if (fi.hasVectors()) {
                            bits = (byte)(bits | 2);
                        }
                        if (fi.omitsNorms()) {
                            bits = (byte)(bits | 0x10);
                        }
                        if (fi.hasPayloads()) {
                            bits = (byte)(bits | 0x20);
                        }
                        if (fi.isIndexed()) {
                            bits = (byte)(bits | 1);
                            assert (indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 || !fi.hasPayloads());
                            if (indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                                bits = (byte)(bits | 0x40);
                            } else if (indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) {
                                bits = (byte)(bits | 4);
                            } else if (indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS) {
                                bits = (byte)(bits | 0xFFFFFF80);
                            }
                        }
                        output.writeString(fi.name);
                        output.writeVInt(fi.number);
                        output.writeByte(bits);
                        byte dv = this.docValuesByte(fi.getDocValuesType());
                        byte nrm = this.docValuesByte(fi.getNormType());
                        assert ((dv & 0xFFFFFFF0) == 0 && (nrm & 0xFFFFFFF0) == 0);
                        byte val = (byte)(0xFF & (nrm << 4 | dv));
                        output.writeByte(val);
                        output.writeStringStringMap(fi.attributes());
                    }
                    success = true;
                    if (!success) break block16;
                }
                catch (Throwable throwable) {
                    if (success) {
                        output.close();
                    } else {
                        IOUtils.closeWhileHandlingException(output);
                    }
                    throw throwable;
                }
                output.close();
                break block17;
            }
            IOUtils.closeWhileHandlingException(output);
        }
    }

    public byte docValuesByte(DocValues.Type type) {
        if (type == null) {
            return 0;
        }
        switch (type) {
            case VAR_INTS: {
                return 1;
            }
            case FLOAT_32: {
                return 2;
            }
            case FLOAT_64: {
                return 3;
            }
            case BYTES_FIXED_STRAIGHT: {
                return 4;
            }
            case BYTES_FIXED_DEREF: {
                return 5;
            }
            case BYTES_VAR_STRAIGHT: {
                return 6;
            }
            case BYTES_VAR_DEREF: {
                return 7;
            }
            case FIXED_INTS_16: {
                return 8;
            }
            case FIXED_INTS_32: {
                return 9;
            }
            case FIXED_INTS_64: {
                return 10;
            }
            case FIXED_INTS_8: {
                return 11;
            }
            case BYTES_FIXED_SORTED: {
                return 12;
            }
            case BYTES_VAR_SORTED: {
                return 13;
            }
        }
        throw new IllegalStateException("unhandled indexValues type " + (Object)((Object)type));
    }
}

