/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license.constraints;

import org.terracotta.license.License;
import org.terracotta.license.LicenseException;
import org.terracotta.license.constraints.LicenseConstraint;

public abstract class FieldAndCapabitlityConstraint
implements LicenseConstraint {
    protected final License license;
    protected final String fieldName;
    protected final String capability;
    protected boolean enforceReverseConstraint = true;

    public FieldAndCapabitlityConstraint(License license, String fieldName, String capability) {
        this.license = license;
        this.fieldName = fieldName;
        this.capability = capability;
    }

    public void setEnforceReverseContraint(boolean flag) {
        this.enforceReverseConstraint = flag;
    }

    public void verify() {
        String value = this.license.getProperty(this.fieldName);
        if (value != null && !this.license.capabilities().contains(this.capability)) {
            throw new LicenseException("Field '" + this.fieldName + "' requires capability '" + this.capability + "' to be enabled first");
        }
        if (this.enforceReverseConstraint && this.license.capabilities().contains(this.capability) && value == null) {
            throw new LicenseException("Capability '" + this.capability + "' is enabled but required field '" + this.fieldName + "' does not have a valid value");
        }
        if (value != null) {
            try {
                this.verifyFieldValue(value);
            }
            catch (Exception e) {
                throw new LicenseException(e.getMessage());
            }
        }
    }

    public abstract void verifyFieldValue(String var1);
}

