/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.factories;

import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.pinning.PinnableSegment;
import com.terracottatech.offheapstore.pinning.PinnableStorageEngine;
import com.terracottatech.offheapstore.pinning.ReadWriteLockedPinnableOffHeapClockCache;
import com.terracottatech.offheapstore.util.Factory;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.FrontEndCacheTier;

public class EhcacheSegmentFactory
implements Factory<PinnableSegment<Serializable, Element>> {
    private final RegisteredEventListeners evictionListener;
    private final Factory<? extends PinnableStorageEngine<? super Serializable, ? super Element>> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;
    private volatile boolean cachePinned;
    private final boolean notify;

    public EhcacheSegmentFactory(RegisteredEventListeners evictionListener, PageSource source, Factory<? extends PinnableStorageEngine<? super Serializable, ? super Element>> storageEngineFactory, int initialTableSize, boolean cachePinned, boolean notify) {
        this.evictionListener = evictionListener;
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.cachePinned = cachePinned;
        this.notify = notify;
    }

    @Override
    public PinnableSegment<Serializable, Element> newInstance() {
        PinnableStorageEngine<? super Serializable, ? super Element> storageEngine = this.storageEngineFactory.newInstance();
        try {
            if (this.notify) {
                return new NotifyingEhcacheSegment(this.evictionListener, this.tableSource, storageEngine, this.tableSize, this.cachePinned);
            }
            return new EhcacheSegment(this.evictionListener, this.tableSource, storageEngine, this.tableSize, this.cachePinned);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    public static class NotifyingEhcacheSegment
    extends EhcacheSegment {
        public NotifyingEhcacheSegment(RegisteredEventListeners evictionListener, PageSource source, PinnableStorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, boolean cachePinned) {
            super(evictionListener, source, storageEngine, tableSize, cachePinned);
        }

        @Override
        public boolean evict(int index, boolean shrink) {
            if (this.cachePinned) {
                throw new OutOfMemoryError("cannot evict pinned cache");
            }
            Element e = (Element)this.getAtTableOffset(index);
            FrontEndCacheTier store = this.evictionListener.getFrontEndCacheTier();
            if (store == null || !this.isPinned(e.getObjectKey()) && store.isEvictionCandidate(e)) {
                boolean evicted = super.evict(index, shrink);
                if (evicted && this.evictionListener.hasCacheEventListeners()) {
                    if (e.isExpired()) {
                        this.evictionListener.notifyElementExpiry(e, false);
                    } else {
                        this.evictionListener.notifyElementEvicted(e, false);
                    }
                }
                return evicted;
            }
            return false;
        }
    }

    public static class EhcacheSegment
    extends ReadWriteLockedPinnableOffHeapClockCache<Serializable, Element> {
        protected final RegisteredEventListeners evictionListener;
        protected volatile boolean cachePinned;
        private volatile Lock masterLock;

        EhcacheSegment(RegisteredEventListeners evictionListener, PageSource source, PinnableStorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, boolean cachePinned) {
            super(source, true, storageEngine, tableSize);
            this.evictionListener = evictionListener;
            this.cachePinned = cachePinned;
        }

        public Lock getMasterLock() {
            return this.masterLock;
        }

        @Override
        protected void storageEngineFailure(Object failure) {
            if (this.cachePinned) {
                StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed.\n");
                sb.append("Cache pinned : ").append(this.cachePinned).append("\n");
                sb.append("Storage Engine : ").append(this.storageEngine);
                throw new OutOfMemoryError(sb.toString());
            }
            super.storageEngineFailure(failure);
        }

        @Override
        public Element fill(Serializable key, Element value) {
            if (this.cachePinned) {
                return this.put(key, value);
            }
            return super.fill(key, value);
        }

        @Override
        public boolean evict(int index, boolean shrink) {
            if (this.cachePinned) {
                throw new OutOfMemoryError("cannot evict pinned cache");
            }
            return super.evict(index, shrink);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object key, Element value, ElementValueComparator comparator) {
            Lock l = this.writeLock();
            l.lock();
            try {
                if (key == null) {
                    throw new NullPointerException();
                }
                if (value == null) {
                    boolean bl = false;
                    return bl;
                }
                Element existing = (Element)super.get(key);
                if (comparator.equals(value, existing)) {
                    super.remove(key);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replace(Serializable key, Element oldValue, Element newValue, ElementValueComparator comparator) {
            Lock l = this.writeLock();
            l.lock();
            try {
                Element existing = (Element)super.get(key);
                if (comparator.equals(oldValue, existing)) {
                    super.put(key, newValue);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        public void registerMasterLock(Lock master) {
            this.masterLock = master;
        }
    }
}

